<?php

namespace TaxyPrinta6\TaxyPrinta6Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PRINTResponse TaxyPrinta6Struct
 * @package TaxyPrinta6
 * @subpackage Structs
 */
class TaxyPrinta6PRINTResponse extends AbstractStructBase
{
    /**
     * The st_flag
     * @var int
     */
    public $st_flag;
    /**
     * The st_title
     * @var string
     */
    public $st_title;
    /**
     * The b64_string
     * @var string
     */
    public $b64_string;
    /**
     * Constructor method for PRINTResponse
     * @uses TaxyPrinta6PRINTResponse::setSt_flag()
     * @uses TaxyPrinta6PRINTResponse::setSt_title()
     * @uses TaxyPrinta6PRINTResponse::setB64_string()
     * @param int $st_flag
     * @param string $st_title
     * @param string $b64_string
     */
    public function __construct($st_flag = null, $st_title = null, $b64_string = null)
    {
        $this
            ->setSt_flag($st_flag)
            ->setSt_title($st_title)
            ->setB64_string($b64_string);
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag()
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \TaxyPrinta6\TaxyPrinta6Struct\TaxyPrinta6PRINTResponse
     */
    public function setSt_flag($st_flag = null)
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title()
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \TaxyPrinta6\TaxyPrinta6Struct\TaxyPrinta6PRINTResponse
     */
    public function setSt_title($st_title = null)
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        return $this;
    }
    /**
     * Get b64_string value
     * @return string|null
     */
    public function getB64_string()
    {
        return $this->b64_string;
    }
    /**
     * Set b64_string value
     * @param string $b64_string
     * @return \TaxyPrinta6\TaxyPrinta6Struct\TaxyPrinta6PRINTResponse
     */
    public function setB64_string($b64_string = null)
    {
        // validation for constraint: string
        if (!is_null($b64_string) && !is_string($b64_string)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($b64_string, true), gettype($b64_string)), __LINE__);
        }
        $this->b64_string = $b64_string;
        return $this;
    }
}
