<?php

namespace Taxy\TaxyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for PRINT TaxyService
 * @package Taxy
 * @subpackage Services
 */
class TaxyPRINT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PRINT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Taxy\TaxyStruct\TaxyPRINT $parameters
     * @return \Taxy\TaxyStruct\TaxyPRINTResponse|bool
     */
    public function _PRINT(\Taxy\TaxyStruct\TaxyPRINT $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PRINT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Taxy\TaxyStruct\TaxyPRINTResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
