<?php

namespace TaxyCreate\TaxyCreateStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INSERTResponse TaxyCreateStruct
 * @package TaxyCreate
 * @subpackage Structs
 */
class TaxyCreateINSERTResponse extends AbstractStructBase
{
    /**
     * The st_flag
     * @var int
     */
    public $st_flag;
    /**
     * The st_title
     * @var string
     */
    public $st_title;
    /**
     * The taxydema_sideta
     * @var string
     */
    public $taxydema_sideta;
    /**
     * The taxydema_doc_sideta
     * @var string
     */
    public $taxydema_doc_sideta;
    /**
     * The taxydema_par_sideta
     * @var string
     */
    public $taxydema_par_sideta;
    /**
     * The taxydema_child_no
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $taxydema_child_no;
    /**
     * Constructor method for INSERTResponse
     * @uses TaxyCreateINSERTResponse::setSt_flag()
     * @uses TaxyCreateINSERTResponse::setSt_title()
     * @uses TaxyCreateINSERTResponse::setTaxydema_sideta()
     * @uses TaxyCreateINSERTResponse::setTaxydema_doc_sideta()
     * @uses TaxyCreateINSERTResponse::setTaxydema_par_sideta()
     * @uses TaxyCreateINSERTResponse::setTaxydema_child_no()
     * @param int $st_flag
     * @param string $st_title
     * @param string $taxydema_sideta
     * @param string $taxydema_doc_sideta
     * @param string $taxydema_par_sideta
     * @param string[] $taxydema_child_no
     */
    public function __construct($st_flag = null, $st_title = null, $taxydema_sideta = null, $taxydema_doc_sideta = null, $taxydema_par_sideta = null, array $taxydema_child_no = array())
    {
        $this
            ->setSt_flag($st_flag)
            ->setSt_title($st_title)
            ->setTaxydema_sideta($taxydema_sideta)
            ->setTaxydema_doc_sideta($taxydema_doc_sideta)
            ->setTaxydema_par_sideta($taxydema_par_sideta)
            ->setTaxydema_child_no($taxydema_child_no);
    }
    /**
     * Get st_flag value
     * @return int|null
     */
    public function getSt_flag()
    {
        return $this->st_flag;
    }
    /**
     * Set st_flag value
     * @param int $st_flag
     * @return \TaxyCreate\TaxyCreateStruct\TaxyCreateINSERTResponse
     */
    public function setSt_flag($st_flag = null)
    {
        // validation for constraint: int
        if (!is_null($st_flag) && !(is_int($st_flag) || ctype_digit($st_flag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($st_flag, true), gettype($st_flag)), __LINE__);
        }
        $this->st_flag = $st_flag;
        return $this;
    }
    /**
     * Get st_title value
     * @return string|null
     */
    public function getSt_title()
    {
        return $this->st_title;
    }
    /**
     * Set st_title value
     * @param string $st_title
     * @return \TaxyCreate\TaxyCreateStruct\TaxyCreateINSERTResponse
     */
    public function setSt_title($st_title = null)
    {
        // validation for constraint: string
        if (!is_null($st_title) && !is_string($st_title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($st_title, true), gettype($st_title)), __LINE__);
        }
        $this->st_title = $st_title;
        return $this;
    }
    /**
     * Get taxydema_sideta value
     * @return string|null
     */
    public function getTaxydema_sideta()
    {
        return $this->taxydema_sideta;
    }
    /**
     * Set taxydema_sideta value
     * @param string $taxydema_sideta
     * @return \TaxyCreate\TaxyCreateStruct\TaxyCreateINSERTResponse
     */
    public function setTaxydema_sideta($taxydema_sideta = null)
    {
        // validation for constraint: string
        if (!is_null($taxydema_sideta) && !is_string($taxydema_sideta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxydema_sideta, true), gettype($taxydema_sideta)), __LINE__);
        }
        $this->taxydema_sideta = $taxydema_sideta;
        return $this;
    }
    /**
     * Get taxydema_doc_sideta value
     * @return string|null
     */
    public function getTaxydema_doc_sideta()
    {
        return $this->taxydema_doc_sideta;
    }
    /**
     * Set taxydema_doc_sideta value
     * @param string $taxydema_doc_sideta
     * @return \TaxyCreate\TaxyCreateStruct\TaxyCreateINSERTResponse
     */
    public function setTaxydema_doc_sideta($taxydema_doc_sideta = null)
    {
        // validation for constraint: string
        if (!is_null($taxydema_doc_sideta) && !is_string($taxydema_doc_sideta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxydema_doc_sideta, true), gettype($taxydema_doc_sideta)), __LINE__);
        }
        $this->taxydema_doc_sideta = $taxydema_doc_sideta;
        return $this;
    }
    /**
     * Get taxydema_par_sideta value
     * @return string|null
     */
    public function getTaxydema_par_sideta()
    {
        return $this->taxydema_par_sideta;
    }
    /**
     * Set taxydema_par_sideta value
     * @param string $taxydema_par_sideta
     * @return \TaxyCreate\TaxyCreateStruct\TaxyCreateINSERTResponse
     */
    public function setTaxydema_par_sideta($taxydema_par_sideta = null)
    {
        // validation for constraint: string
        if (!is_null($taxydema_par_sideta) && !is_string($taxydema_par_sideta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxydema_par_sideta, true), gettype($taxydema_par_sideta)), __LINE__);
        }
        $this->taxydema_par_sideta = $taxydema_par_sideta;
        return $this;
    }
    /**
     * Get taxydema_child_no value
     * @return string[]|null
     */
    public function getTaxydema_child_no()
    {
        return $this->taxydema_child_no;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxydema_child_no method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxydema_child_no method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxydema_child_noForArrayConstraintsFromSetTaxydema_child_no(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $iNSERTResponseTaxydema_child_noItem) {
            // validation for constraint: itemType
            if (!is_string($iNSERTResponseTaxydema_child_noItem)) {
                $invalidValues[] = is_object($iNSERTResponseTaxydema_child_noItem) ? get_class($iNSERTResponseTaxydema_child_noItem) : sprintf('%s(%s)', gettype($iNSERTResponseTaxydema_child_noItem), var_export($iNSERTResponseTaxydema_child_noItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxydema_child_no property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxydema_child_no value
     * @throws \InvalidArgumentException
     * @param string[] $taxydema_child_no
     * @return \TaxyCreate\TaxyCreateStruct\TaxyCreateINSERTResponse
     */
    public function setTaxydema_child_no(array $taxydema_child_no = array())
    {
        // validation for constraint: array
        if ('' !== ($taxydema_child_noArrayErrorMessage = self::validateTaxydema_child_noForArrayConstraintsFromSetTaxydema_child_no($taxydema_child_no))) {
            throw new \InvalidArgumentException($taxydema_child_noArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($taxydema_child_no) && count($taxydema_child_no) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($taxydema_child_no)), __LINE__);
        }
        $this->taxydema_child_no = $taxydema_child_no;
        return $this;
    }
    /**
     * Add item to taxydema_child_no value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \TaxyCreate\TaxyCreateStruct\TaxyCreateINSERTResponse
     */
    public function addToTaxydema_child_no($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The taxydema_child_no property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->taxydema_child_no) && count($this->taxydema_child_no) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->taxydema_child_no)), __LINE__);
        }
        $this->taxydema_child_no[] = $item;
        return $this;
    }
}
