<?php

namespace Taxy\TaxyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for INSERT TaxyService
 * @package Taxy
 * @subpackage Services
 */
class TaxyINSERT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named INSERT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Taxy\TaxyStruct\TaxyINSERT $parameters
     * @return \Taxy\TaxyStruct\TaxyINSERTResponse|bool
     */
    public function INSERT(\Taxy\TaxyStruct\TaxyINSERT $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->INSERT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Taxy\TaxyStruct\TaxyINSERTResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
