<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for duploFault StructType
 * @subpackage Structs
 */
class DuploFault extends AbstractStructBase
{
    /**
     * The faultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faultCode;
    /**
     * The faultMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faultMessage;
    /**
     * Constructor method for duploFault
     * @uses DuploFault::setFaultCode()
     * @uses DuploFault::setFaultMessage()
     * @param string $faultCode
     * @param string $faultMessage
     */
    public function __construct($faultCode = null, $faultMessage = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setFaultMessage($faultMessage);
    }
    /**
     * Get faultCode value
     * @return string|null
     */
    public function getFaultCode()
    {
        return $this->faultCode;
    }
    /**
     * Set faultCode value
     * @param string $faultCode
     * @return \StructType\DuploFault
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultCode, true), gettype($faultCode)), __LINE__);
        }
        $this->faultCode = $faultCode;
        return $this;
    }
    /**
     * Get faultMessage value
     * @return string|null
     */
    public function getFaultMessage()
    {
        return $this->faultMessage;
    }
    /**
     * Set faultMessage value
     * @param string $faultMessage
     * @return \StructType\DuploFault
     */
    public function setFaultMessage($faultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($faultMessage) && !is_string($faultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultMessage, true), gettype($faultMessage)), __LINE__);
        }
        $this->faultMessage = $faultMessage;
        return $this;
    }
}
