<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cameraInfo StructType
 * @subpackage Structs
 */
class CameraInfo extends AbstractStructBase
{
    /**
     * The azimut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $azimut;
    /**
     * The camera
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $camera;
    /**
     * The camera_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $camera_id;
    /**
     * The camera_model
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $camera_model;
    /**
     * The camera_place
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $camera_place;
    /**
     * The gps_x
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $gps_x;
    /**
     * The gps_y
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $gps_y;
    /**
     * The lane_num
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lane_num;
    /**
     * The p_node
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $p_node;
    /**
     * The print_name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $print_name;
    /**
     * The priz_arh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priz_arh;
    /**
     * The serial_no
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serial_no;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The v_class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $v_class;
    /**
     * Constructor method for cameraInfo
     * @uses CameraInfo::setAzimut()
     * @uses CameraInfo::setCamera()
     * @uses CameraInfo::setCamera_id()
     * @uses CameraInfo::setCamera_model()
     * @uses CameraInfo::setCamera_place()
     * @uses CameraInfo::setGps_x()
     * @uses CameraInfo::setGps_y()
     * @uses CameraInfo::setLane_num()
     * @uses CameraInfo::setP_node()
     * @uses CameraInfo::setPrint_name()
     * @uses CameraInfo::setPriz_arh()
     * @uses CameraInfo::setSerial_no()
     * @uses CameraInfo::setType()
     * @uses CameraInfo::setV_class()
     * @param float $azimut
     * @param string $camera
     * @param int $camera_id
     * @param string $camera_model
     * @param string $camera_place
     * @param float $gps_x
     * @param float $gps_y
     * @param int $lane_num
     * @param int $p_node
     * @param string $print_name
     * @param string $priz_arh
     * @param string $serial_no
     * @param string $type
     * @param string $v_class
     */
    public function __construct($azimut = null, $camera = null, $camera_id = null, $camera_model = null, $camera_place = null, $gps_x = null, $gps_y = null, $lane_num = null, $p_node = null, $print_name = null, $priz_arh = null, $serial_no = null, $type = null, $v_class = null)
    {
        $this
            ->setAzimut($azimut)
            ->setCamera($camera)
            ->setCamera_id($camera_id)
            ->setCamera_model($camera_model)
            ->setCamera_place($camera_place)
            ->setGps_x($gps_x)
            ->setGps_y($gps_y)
            ->setLane_num($lane_num)
            ->setP_node($p_node)
            ->setPrint_name($print_name)
            ->setPriz_arh($priz_arh)
            ->setSerial_no($serial_no)
            ->setType($type)
            ->setV_class($v_class);
    }
    /**
     * Get azimut value
     * @return float|null
     */
    public function getAzimut()
    {
        return $this->azimut;
    }
    /**
     * Set azimut value
     * @param float $azimut
     * @return \StructType\CameraInfo
     */
    public function setAzimut($azimut = null)
    {
        // validation for constraint: float
        if (!is_null($azimut) && !(is_float($azimut) || is_numeric($azimut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($azimut, true), gettype($azimut)), __LINE__);
        }
        $this->azimut = $azimut;
        return $this;
    }
    /**
     * Get camera value
     * @return string|null
     */
    public function getCamera()
    {
        return $this->camera;
    }
    /**
     * Set camera value
     * @param string $camera
     * @return \StructType\CameraInfo
     */
    public function setCamera($camera = null)
    {
        // validation for constraint: string
        if (!is_null($camera) && !is_string($camera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($camera, true), gettype($camera)), __LINE__);
        }
        $this->camera = $camera;
        return $this;
    }
    /**
     * Get camera_id value
     * @return int|null
     */
    public function getCamera_id()
    {
        return $this->camera_id;
    }
    /**
     * Set camera_id value
     * @param int $camera_id
     * @return \StructType\CameraInfo
     */
    public function setCamera_id($camera_id = null)
    {
        // validation for constraint: int
        if (!is_null($camera_id) && !(is_int($camera_id) || ctype_digit($camera_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($camera_id, true), gettype($camera_id)), __LINE__);
        }
        $this->camera_id = $camera_id;
        return $this;
    }
    /**
     * Get camera_model value
     * @return string|null
     */
    public function getCamera_model()
    {
        return $this->camera_model;
    }
    /**
     * Set camera_model value
     * @param string $camera_model
     * @return \StructType\CameraInfo
     */
    public function setCamera_model($camera_model = null)
    {
        // validation for constraint: string
        if (!is_null($camera_model) && !is_string($camera_model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($camera_model, true), gettype($camera_model)), __LINE__);
        }
        $this->camera_model = $camera_model;
        return $this;
    }
    /**
     * Get camera_place value
     * @return string|null
     */
    public function getCamera_place()
    {
        return $this->camera_place;
    }
    /**
     * Set camera_place value
     * @param string $camera_place
     * @return \StructType\CameraInfo
     */
    public function setCamera_place($camera_place = null)
    {
        // validation for constraint: string
        if (!is_null($camera_place) && !is_string($camera_place)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($camera_place, true), gettype($camera_place)), __LINE__);
        }
        $this->camera_place = $camera_place;
        return $this;
    }
    /**
     * Get gps_x value
     * @return float|null
     */
    public function getGps_x()
    {
        return $this->gps_x;
    }
    /**
     * Set gps_x value
     * @param float $gps_x
     * @return \StructType\CameraInfo
     */
    public function setGps_x($gps_x = null)
    {
        // validation for constraint: float
        if (!is_null($gps_x) && !(is_float($gps_x) || is_numeric($gps_x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gps_x, true), gettype($gps_x)), __LINE__);
        }
        $this->gps_x = $gps_x;
        return $this;
    }
    /**
     * Get gps_y value
     * @return float|null
     */
    public function getGps_y()
    {
        return $this->gps_y;
    }
    /**
     * Set gps_y value
     * @param float $gps_y
     * @return \StructType\CameraInfo
     */
    public function setGps_y($gps_y = null)
    {
        // validation for constraint: float
        if (!is_null($gps_y) && !(is_float($gps_y) || is_numeric($gps_y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gps_y, true), gettype($gps_y)), __LINE__);
        }
        $this->gps_y = $gps_y;
        return $this;
    }
    /**
     * Get lane_num value
     * @return int|null
     */
    public function getLane_num()
    {
        return $this->lane_num;
    }
    /**
     * Set lane_num value
     * @param int $lane_num
     * @return \StructType\CameraInfo
     */
    public function setLane_num($lane_num = null)
    {
        // validation for constraint: int
        if (!is_null($lane_num) && !(is_int($lane_num) || ctype_digit($lane_num))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lane_num, true), gettype($lane_num)), __LINE__);
        }
        $this->lane_num = $lane_num;
        return $this;
    }
    /**
     * Get p_node value
     * @return int|null
     */
    public function getP_node()
    {
        return $this->p_node;
    }
    /**
     * Set p_node value
     * @param int $p_node
     * @return \StructType\CameraInfo
     */
    public function setP_node($p_node = null)
    {
        // validation for constraint: int
        if (!is_null($p_node) && !(is_int($p_node) || ctype_digit($p_node))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($p_node, true), gettype($p_node)), __LINE__);
        }
        $this->p_node = $p_node;
        return $this;
    }
    /**
     * Get print_name value
     * @return string|null
     */
    public function getPrint_name()
    {
        return $this->print_name;
    }
    /**
     * Set print_name value
     * @param string $print_name
     * @return \StructType\CameraInfo
     */
    public function setPrint_name($print_name = null)
    {
        // validation for constraint: string
        if (!is_null($print_name) && !is_string($print_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($print_name, true), gettype($print_name)), __LINE__);
        }
        $this->print_name = $print_name;
        return $this;
    }
    /**
     * Get priz_arh value
     * @return string|null
     */
    public function getPriz_arh()
    {
        return $this->priz_arh;
    }
    /**
     * Set priz_arh value
     * @param string $priz_arh
     * @return \StructType\CameraInfo
     */
    public function setPriz_arh($priz_arh = null)
    {
        // validation for constraint: string
        if (!is_null($priz_arh) && !is_string($priz_arh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priz_arh, true), gettype($priz_arh)), __LINE__);
        }
        $this->priz_arh = $priz_arh;
        return $this;
    }
    /**
     * Get serial_no value
     * @return string|null
     */
    public function getSerial_no()
    {
        return $this->serial_no;
    }
    /**
     * Set serial_no value
     * @param string $serial_no
     * @return \StructType\CameraInfo
     */
    public function setSerial_no($serial_no = null)
    {
        // validation for constraint: string
        if (!is_null($serial_no) && !is_string($serial_no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial_no, true), gettype($serial_no)), __LINE__);
        }
        $this->serial_no = $serial_no;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\CameraInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get v_class value
     * @return string|null
     */
    public function getV_class()
    {
        return $this->v_class;
    }
    /**
     * Set v_class value
     * @param string $v_class
     * @return \StructType\CameraInfo
     */
    public function setV_class($v_class = null)
    {
        // validation for constraint: string
        if (!is_null($v_class) && !is_string($v_class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_class, true), gettype($v_class)), __LINE__);
        }
        $this->v_class = $v_class;
        return $this;
    }
}
