<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for trCheckIn StructType
 * @subpackage Structs
 */
class TrCheckIn extends AbstractStructBase
{
    /**
     * The v_time_check
     * @var string
     */
    public $v_time_check;
    /**
     * The v_camera
     * @var string
     */
    public $v_camera;
    /**
     * The v_gps_x
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $v_gps_x;
    /**
     * The v_gps_y
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $v_gps_y;
    /**
     * The v_azimut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $v_azimut;
    /**
     * The v_direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $v_direction;
    /**
     * The v_speed_limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $v_speed_limit;
    /**
     * The v_speed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $v_speed;
    /**
     * The v_regno_country_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $v_regno_country_id;
    /**
     * The v_regno_color_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $v_regno_color_id;
    /**
     * The v_recognition_accuracy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $v_recognition_accuracy;
    /**
     * The v_regno
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $v_regno;
    /**
     * The v_pr_viol
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $v_pr_viol;
    /**
     * The v_parking_num
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $v_parking_num;
    /**
     * The v_parking_zone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $v_parking_zone;
    /**
     * The v_lane_num
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $v_lane_num;
    /**
     * The v_camera_place
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $v_camera_place;
    /**
     * The v_photo_grz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $v_photo_grz;
    /**
     * The v_photo_ts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $v_photo_ts;
    /**
     * The v_extra_data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $v_extra_data;
    /**
     * Constructor method for trCheckIn
     * @uses TrCheckIn::setV_time_check()
     * @uses TrCheckIn::setV_camera()
     * @uses TrCheckIn::setV_gps_x()
     * @uses TrCheckIn::setV_gps_y()
     * @uses TrCheckIn::setV_azimut()
     * @uses TrCheckIn::setV_direction()
     * @uses TrCheckIn::setV_speed_limit()
     * @uses TrCheckIn::setV_speed()
     * @uses TrCheckIn::setV_regno_country_id()
     * @uses TrCheckIn::setV_regno_color_id()
     * @uses TrCheckIn::setV_recognition_accuracy()
     * @uses TrCheckIn::setV_regno()
     * @uses TrCheckIn::setV_pr_viol()
     * @uses TrCheckIn::setV_parking_num()
     * @uses TrCheckIn::setV_parking_zone()
     * @uses TrCheckIn::setV_lane_num()
     * @uses TrCheckIn::setV_camera_place()
     * @uses TrCheckIn::setV_photo_grz()
     * @uses TrCheckIn::setV_photo_ts()
     * @uses TrCheckIn::setV_extra_data()
     * @param string $v_time_check
     * @param string $v_camera
     * @param float $v_gps_x
     * @param float $v_gps_y
     * @param float $v_azimut
     * @param string $v_direction
     * @param int $v_speed_limit
     * @param float $v_speed
     * @param string $v_regno_country_id
     * @param int $v_regno_color_id
     * @param float $v_recognition_accuracy
     * @param string $v_regno
     * @param int[] $v_pr_viol
     * @param int $v_parking_num
     * @param int $v_parking_zone
     * @param int $v_lane_num
     * @param string $v_camera_place
     * @param string $v_photo_grz
     * @param string $v_photo_ts
     * @param string $v_extra_data
     */
    public function __construct($v_time_check = null, $v_camera = null, $v_gps_x = null, $v_gps_y = null, $v_azimut = null, $v_direction = null, $v_speed_limit = null, $v_speed = null, $v_regno_country_id = null, $v_regno_color_id = null, $v_recognition_accuracy = null, $v_regno = null, array $v_pr_viol = array(), $v_parking_num = null, $v_parking_zone = null, $v_lane_num = null, $v_camera_place = null, $v_photo_grz = null, $v_photo_ts = null, $v_extra_data = null)
    {
        $this
            ->setV_time_check($v_time_check)
            ->setV_camera($v_camera)
            ->setV_gps_x($v_gps_x)
            ->setV_gps_y($v_gps_y)
            ->setV_azimut($v_azimut)
            ->setV_direction($v_direction)
            ->setV_speed_limit($v_speed_limit)
            ->setV_speed($v_speed)
            ->setV_regno_country_id($v_regno_country_id)
            ->setV_regno_color_id($v_regno_color_id)
            ->setV_recognition_accuracy($v_recognition_accuracy)
            ->setV_regno($v_regno)
            ->setV_pr_viol($v_pr_viol)
            ->setV_parking_num($v_parking_num)
            ->setV_parking_zone($v_parking_zone)
            ->setV_lane_num($v_lane_num)
            ->setV_camera_place($v_camera_place)
            ->setV_photo_grz($v_photo_grz)
            ->setV_photo_ts($v_photo_ts)
            ->setV_extra_data($v_extra_data);
    }
    /**
     * Get v_time_check value
     * @return string|null
     */
    public function getV_time_check()
    {
        return $this->v_time_check;
    }
    /**
     * Set v_time_check value
     * @param string $v_time_check
     * @return \StructType\TrCheckIn
     */
    public function setV_time_check($v_time_check = null)
    {
        // validation for constraint: string
        if (!is_null($v_time_check) && !is_string($v_time_check)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_time_check, true), gettype($v_time_check)), __LINE__);
        }
        $this->v_time_check = $v_time_check;
        return $this;
    }
    /**
     * Get v_camera value
     * @return string|null
     */
    public function getV_camera()
    {
        return $this->v_camera;
    }
    /**
     * Set v_camera value
     * @param string $v_camera
     * @return \StructType\TrCheckIn
     */
    public function setV_camera($v_camera = null)
    {
        // validation for constraint: string
        if (!is_null($v_camera) && !is_string($v_camera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_camera, true), gettype($v_camera)), __LINE__);
        }
        $this->v_camera = $v_camera;
        return $this;
    }
    /**
     * Get v_gps_x value
     * @return float|null
     */
    public function getV_gps_x()
    {
        return $this->v_gps_x;
    }
    /**
     * Set v_gps_x value
     * @param float $v_gps_x
     * @return \StructType\TrCheckIn
     */
    public function setV_gps_x($v_gps_x = null)
    {
        // validation for constraint: float
        if (!is_null($v_gps_x) && !(is_float($v_gps_x) || is_numeric($v_gps_x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v_gps_x, true), gettype($v_gps_x)), __LINE__);
        }
        $this->v_gps_x = $v_gps_x;
        return $this;
    }
    /**
     * Get v_gps_y value
     * @return float|null
     */
    public function getV_gps_y()
    {
        return $this->v_gps_y;
    }
    /**
     * Set v_gps_y value
     * @param float $v_gps_y
     * @return \StructType\TrCheckIn
     */
    public function setV_gps_y($v_gps_y = null)
    {
        // validation for constraint: float
        if (!is_null($v_gps_y) && !(is_float($v_gps_y) || is_numeric($v_gps_y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v_gps_y, true), gettype($v_gps_y)), __LINE__);
        }
        $this->v_gps_y = $v_gps_y;
        return $this;
    }
    /**
     * Get v_azimut value
     * @return float|null
     */
    public function getV_azimut()
    {
        return $this->v_azimut;
    }
    /**
     * Set v_azimut value
     * @param float $v_azimut
     * @return \StructType\TrCheckIn
     */
    public function setV_azimut($v_azimut = null)
    {
        // validation for constraint: float
        if (!is_null($v_azimut) && !(is_float($v_azimut) || is_numeric($v_azimut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v_azimut, true), gettype($v_azimut)), __LINE__);
        }
        $this->v_azimut = $v_azimut;
        return $this;
    }
    /**
     * Get v_direction value
     * @return string|null
     */
    public function getV_direction()
    {
        return $this->v_direction;
    }
    /**
     * Set v_direction value
     * @param string $v_direction
     * @return \StructType\TrCheckIn
     */
    public function setV_direction($v_direction = null)
    {
        // validation for constraint: string
        if (!is_null($v_direction) && !is_string($v_direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_direction, true), gettype($v_direction)), __LINE__);
        }
        $this->v_direction = $v_direction;
        return $this;
    }
    /**
     * Get v_speed_limit value
     * @return int|null
     */
    public function getV_speed_limit()
    {
        return $this->v_speed_limit;
    }
    /**
     * Set v_speed_limit value
     * @param int $v_speed_limit
     * @return \StructType\TrCheckIn
     */
    public function setV_speed_limit($v_speed_limit = null)
    {
        // validation for constraint: int
        if (!is_null($v_speed_limit) && !(is_int($v_speed_limit) || ctype_digit($v_speed_limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v_speed_limit, true), gettype($v_speed_limit)), __LINE__);
        }
        $this->v_speed_limit = $v_speed_limit;
        return $this;
    }
    /**
     * Get v_speed value
     * @return float|null
     */
    public function getV_speed()
    {
        return $this->v_speed;
    }
    /**
     * Set v_speed value
     * @param float $v_speed
     * @return \StructType\TrCheckIn
     */
    public function setV_speed($v_speed = null)
    {
        // validation for constraint: float
        if (!is_null($v_speed) && !(is_float($v_speed) || is_numeric($v_speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v_speed, true), gettype($v_speed)), __LINE__);
        }
        $this->v_speed = $v_speed;
        return $this;
    }
    /**
     * Get v_regno_country_id value
     * @return string|null
     */
    public function getV_regno_country_id()
    {
        return $this->v_regno_country_id;
    }
    /**
     * Set v_regno_country_id value
     * @param string $v_regno_country_id
     * @return \StructType\TrCheckIn
     */
    public function setV_regno_country_id($v_regno_country_id = null)
    {
        // validation for constraint: string
        if (!is_null($v_regno_country_id) && !is_string($v_regno_country_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_regno_country_id, true), gettype($v_regno_country_id)), __LINE__);
        }
        $this->v_regno_country_id = $v_regno_country_id;
        return $this;
    }
    /**
     * Get v_regno_color_id value
     * @return int|null
     */
    public function getV_regno_color_id()
    {
        return $this->v_regno_color_id;
    }
    /**
     * Set v_regno_color_id value
     * @param int $v_regno_color_id
     * @return \StructType\TrCheckIn
     */
    public function setV_regno_color_id($v_regno_color_id = null)
    {
        // validation for constraint: int
        if (!is_null($v_regno_color_id) && !(is_int($v_regno_color_id) || ctype_digit($v_regno_color_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v_regno_color_id, true), gettype($v_regno_color_id)), __LINE__);
        }
        $this->v_regno_color_id = $v_regno_color_id;
        return $this;
    }
    /**
     * Get v_recognition_accuracy value
     * @return float|null
     */
    public function getV_recognition_accuracy()
    {
        return $this->v_recognition_accuracy;
    }
    /**
     * Set v_recognition_accuracy value
     * @param float $v_recognition_accuracy
     * @return \StructType\TrCheckIn
     */
    public function setV_recognition_accuracy($v_recognition_accuracy = null)
    {
        // validation for constraint: float
        if (!is_null($v_recognition_accuracy) && !(is_float($v_recognition_accuracy) || is_numeric($v_recognition_accuracy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($v_recognition_accuracy, true), gettype($v_recognition_accuracy)), __LINE__);
        }
        $this->v_recognition_accuracy = $v_recognition_accuracy;
        return $this;
    }
    /**
     * Get v_regno value
     * @return string|null
     */
    public function getV_regno()
    {
        return $this->v_regno;
    }
    /**
     * Set v_regno value
     * @param string $v_regno
     * @return \StructType\TrCheckIn
     */
    public function setV_regno($v_regno = null)
    {
        // validation for constraint: string
        if (!is_null($v_regno) && !is_string($v_regno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_regno, true), gettype($v_regno)), __LINE__);
        }
        $this->v_regno = $v_regno;
        return $this;
    }
    /**
     * Get v_pr_viol value
     * @return int[]|null
     */
    public function getV_pr_viol()
    {
        return $this->v_pr_viol;
    }
    /**
     * This method is responsible for validating the values passed to the setV_pr_viol method
     * This method is willingly generated in order to preserve the one-line inline validation within the setV_pr_viol method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateV_pr_violForArrayConstraintsFromSetV_pr_viol(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trCheckInV_pr_violItem) {
            // validation for constraint: itemType
            if (!(is_int($trCheckInV_pr_violItem) || ctype_digit($trCheckInV_pr_violItem))) {
                $invalidValues[] = is_object($trCheckInV_pr_violItem) ? get_class($trCheckInV_pr_violItem) : sprintf('%s(%s)', gettype($trCheckInV_pr_violItem), var_export($trCheckInV_pr_violItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The v_pr_viol property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set v_pr_viol value
     * @throws \InvalidArgumentException
     * @param int[] $v_pr_viol
     * @return \StructType\TrCheckIn
     */
    public function setV_pr_viol(array $v_pr_viol = array())
    {
        // validation for constraint: array
        if ('' !== ($v_pr_violArrayErrorMessage = self::validateV_pr_violForArrayConstraintsFromSetV_pr_viol($v_pr_viol))) {
            throw new \InvalidArgumentException($v_pr_violArrayErrorMessage, __LINE__);
        }
        $this->v_pr_viol = $v_pr_viol;
        return $this;
    }
    /**
     * Add item to v_pr_viol value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TrCheckIn
     */
    public function addToV_pr_viol($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The v_pr_viol property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->v_pr_viol[] = $item;
        return $this;
    }
    /**
     * Get v_parking_num value
     * @return int|null
     */
    public function getV_parking_num()
    {
        return $this->v_parking_num;
    }
    /**
     * Set v_parking_num value
     * @param int $v_parking_num
     * @return \StructType\TrCheckIn
     */
    public function setV_parking_num($v_parking_num = null)
    {
        // validation for constraint: int
        if (!is_null($v_parking_num) && !(is_int($v_parking_num) || ctype_digit($v_parking_num))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v_parking_num, true), gettype($v_parking_num)), __LINE__);
        }
        $this->v_parking_num = $v_parking_num;
        return $this;
    }
    /**
     * Get v_parking_zone value
     * @return int|null
     */
    public function getV_parking_zone()
    {
        return $this->v_parking_zone;
    }
    /**
     * Set v_parking_zone value
     * @param int $v_parking_zone
     * @return \StructType\TrCheckIn
     */
    public function setV_parking_zone($v_parking_zone = null)
    {
        // validation for constraint: int
        if (!is_null($v_parking_zone) && !(is_int($v_parking_zone) || ctype_digit($v_parking_zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v_parking_zone, true), gettype($v_parking_zone)), __LINE__);
        }
        $this->v_parking_zone = $v_parking_zone;
        return $this;
    }
    /**
     * Get v_lane_num value
     * @return int|null
     */
    public function getV_lane_num()
    {
        return $this->v_lane_num;
    }
    /**
     * Set v_lane_num value
     * @param int $v_lane_num
     * @return \StructType\TrCheckIn
     */
    public function setV_lane_num($v_lane_num = null)
    {
        // validation for constraint: int
        if (!is_null($v_lane_num) && !(is_int($v_lane_num) || ctype_digit($v_lane_num))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v_lane_num, true), gettype($v_lane_num)), __LINE__);
        }
        $this->v_lane_num = $v_lane_num;
        return $this;
    }
    /**
     * Get v_camera_place value
     * @return string|null
     */
    public function getV_camera_place()
    {
        return $this->v_camera_place;
    }
    /**
     * Set v_camera_place value
     * @param string $v_camera_place
     * @return \StructType\TrCheckIn
     */
    public function setV_camera_place($v_camera_place = null)
    {
        // validation for constraint: string
        if (!is_null($v_camera_place) && !is_string($v_camera_place)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_camera_place, true), gettype($v_camera_place)), __LINE__);
        }
        $this->v_camera_place = $v_camera_place;
        return $this;
    }
    /**
     * Get v_photo_grz value
     * @return string|null
     */
    public function getV_photo_grz()
    {
        return $this->v_photo_grz;
    }
    /**
     * Set v_photo_grz value
     * @param string $v_photo_grz
     * @return \StructType\TrCheckIn
     */
    public function setV_photo_grz($v_photo_grz = null)
    {
        // validation for constraint: string
        if (!is_null($v_photo_grz) && !is_string($v_photo_grz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_photo_grz, true), gettype($v_photo_grz)), __LINE__);
        }
        $this->v_photo_grz = $v_photo_grz;
        return $this;
    }
    /**
     * Get v_photo_ts value
     * @return string|null
     */
    public function getV_photo_ts()
    {
        return $this->v_photo_ts;
    }
    /**
     * Set v_photo_ts value
     * @param string $v_photo_ts
     * @return \StructType\TrCheckIn
     */
    public function setV_photo_ts($v_photo_ts = null)
    {
        // validation for constraint: string
        if (!is_null($v_photo_ts) && !is_string($v_photo_ts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_photo_ts, true), gettype($v_photo_ts)), __LINE__);
        }
        $this->v_photo_ts = $v_photo_ts;
        return $this;
    }
    /**
     * Get v_extra_data value
     * @return string|null
     */
    public function getV_extra_data()
    {
        return $this->v_extra_data;
    }
    /**
     * Set v_extra_data value
     * @param string $v_extra_data
     * @return \StructType\TrCheckIn
     */
    public function setV_extra_data($v_extra_data = null)
    {
        // validation for constraint: string
        if (!is_null($v_extra_data) && !is_string($v_extra_data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v_extra_data, true), gettype($v_extra_data)), __LINE__);
        }
        $this->v_extra_data = $v_extra_data;
        return $this;
    }
}
