<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for message StructType
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The tr_checkIn
     * @var \StructType\TrCheckIn
     */
    public $tr_checkIn;
    /**
     * The photo_extra
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhotoExtra[]
     */
    public $photo_extra;
    /**
     * Constructor method for message
     * @uses Message::setTr_checkIn()
     * @uses Message::setPhoto_extra()
     * @param \StructType\TrCheckIn $tr_checkIn
     * @param \StructType\PhotoExtra[] $photo_extra
     */
    public function __construct(\StructType\TrCheckIn $tr_checkIn = null, array $photo_extra = array())
    {
        $this
            ->setTr_checkIn($tr_checkIn)
            ->setPhoto_extra($photo_extra);
    }
    /**
     * Get tr_checkIn value
     * @return \StructType\TrCheckIn|null
     */
    public function getTr_checkIn()
    {
        return $this->tr_checkIn;
    }
    /**
     * Set tr_checkIn value
     * @param \StructType\TrCheckIn $tr_checkIn
     * @return \StructType\Message
     */
    public function setTr_checkIn(\StructType\TrCheckIn $tr_checkIn = null)
    {
        $this->tr_checkIn = $tr_checkIn;
        return $this;
    }
    /**
     * Get photo_extra value
     * @return \StructType\PhotoExtra[]|null
     */
    public function getPhoto_extra()
    {
        return $this->photo_extra;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoto_extra method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoto_extra method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoto_extraForArrayConstraintsFromSetPhoto_extra(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $messagePhoto_extraItem) {
            // validation for constraint: itemType
            if (!$messagePhoto_extraItem instanceof \StructType\PhotoExtra) {
                $invalidValues[] = is_object($messagePhoto_extraItem) ? get_class($messagePhoto_extraItem) : sprintf('%s(%s)', gettype($messagePhoto_extraItem), var_export($messagePhoto_extraItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The photo_extra property can only contain items of type \StructType\PhotoExtra, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set photo_extra value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoExtra[] $photo_extra
     * @return \StructType\Message
     */
    public function setPhoto_extra(array $photo_extra = array())
    {
        // validation for constraint: array
        if ('' !== ($photo_extraArrayErrorMessage = self::validatePhoto_extraForArrayConstraintsFromSetPhoto_extra($photo_extra))) {
            throw new \InvalidArgumentException($photo_extraArrayErrorMessage, __LINE__);
        }
        $this->photo_extra = $photo_extra;
        return $this;
    }
    /**
     * Add item to photo_extra value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoExtra $item
     * @return \StructType\Message
     */
    public function addToPhoto_extra(\StructType\PhotoExtra $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhotoExtra) {
            throw new \InvalidArgumentException(sprintf('The photo_extra property can only contain items of type \StructType\PhotoExtra, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->photo_extra[] = $item;
        return $this;
    }
}
