<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceDetailRequest StructType
 * @subpackage Structs
 */
class ReferenceDetailRequest extends ReferenceBaseRequest
{
    /**
     * The Searchmode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Searchmode;
    /**
     * The GetImages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GetImages;
    /**
     * The GetPhotos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $GetPhotos;
    /**
     * The GetParsedInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $GetParsedInfo;
    /**
     * The GetServices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $GetServices;
    /**
     * The GetLastTrace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $GetLastTrace;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Options
     */
    public $Options;
    /**
     * Constructor method for ReferenceDetailRequest
     * @uses ReferenceDetailRequest::setSearchmode()
     * @uses ReferenceDetailRequest::setGetImages()
     * @uses ReferenceDetailRequest::setGetPhotos()
     * @uses ReferenceDetailRequest::setGetParsedInfo()
     * @uses ReferenceDetailRequest::setGetServices()
     * @uses ReferenceDetailRequest::setGetLastTrace()
     * @uses ReferenceDetailRequest::setOptions()
     * @param string $searchmode
     * @param bool $getImages
     * @param bool $getPhotos
     * @param bool $getParsedInfo
     * @param bool $getServices
     * @param bool $getLastTrace
     * @param \Dpd\StructType\Options $options
     */
    public function __construct($searchmode = null, $getImages = null, $getPhotos = null, $getParsedInfo = null, $getServices = null, $getLastTrace = null, \Dpd\StructType\Options $options = null)
    {
        $this
            ->setSearchmode($searchmode)
            ->setGetImages($getImages)
            ->setGetPhotos($getPhotos)
            ->setGetParsedInfo($getParsedInfo)
            ->setGetServices($getServices)
            ->setGetLastTrace($getLastTrace)
            ->setOptions($options);
    }
    /**
     * Get Searchmode value
     * @return string
     */
    public function getSearchmode()
    {
        return $this->Searchmode;
    }
    /**
     * Set Searchmode value
     * @uses \Dpd\EnumType\ReferenceSearchMode::valueIsValid()
     * @uses \Dpd\EnumType\ReferenceSearchMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchmode
     * @return \Dpd\StructType\ReferenceDetailRequest
     */
    public function setSearchmode($searchmode = null)
    {
        // validation for constraint: enumeration
        if (!\Dpd\EnumType\ReferenceSearchMode::valueIsValid($searchmode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Dpd\EnumType\ReferenceSearchMode', is_array($searchmode) ? implode(', ', $searchmode) : var_export($searchmode, true), implode(', ', \Dpd\EnumType\ReferenceSearchMode::getValidValues())), __LINE__);
        }
        $this->Searchmode = $searchmode;
        return $this;
    }
    /**
     * Get GetImages value
     * @return bool
     */
    public function getGetImages()
    {
        return $this->GetImages;
    }
    /**
     * Set GetImages value
     * @param bool $getImages
     * @return \Dpd\StructType\ReferenceDetailRequest
     */
    public function setGetImages($getImages = null)
    {
        // validation for constraint: boolean
        if (!is_null($getImages) && !is_bool($getImages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getImages, true), gettype($getImages)), __LINE__);
        }
        $this->GetImages = $getImages;
        return $this;
    }
    /**
     * Get GetPhotos value
     * @return bool
     */
    public function getGetPhotos()
    {
        return $this->GetPhotos;
    }
    /**
     * Set GetPhotos value
     * @param bool $getPhotos
     * @return \Dpd\StructType\ReferenceDetailRequest
     */
    public function setGetPhotos($getPhotos = null)
    {
        // validation for constraint: boolean
        if (!is_null($getPhotos) && !is_bool($getPhotos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getPhotos, true), gettype($getPhotos)), __LINE__);
        }
        $this->GetPhotos = $getPhotos;
        return $this;
    }
    /**
     * Get GetParsedInfo value
     * @return bool
     */
    public function getGetParsedInfo()
    {
        return $this->GetParsedInfo;
    }
    /**
     * Set GetParsedInfo value
     * @param bool $getParsedInfo
     * @return \Dpd\StructType\ReferenceDetailRequest
     */
    public function setGetParsedInfo($getParsedInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($getParsedInfo) && !is_bool($getParsedInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getParsedInfo, true), gettype($getParsedInfo)), __LINE__);
        }
        $this->GetParsedInfo = $getParsedInfo;
        return $this;
    }
    /**
     * Get GetServices value
     * @return bool
     */
    public function getGetServices()
    {
        return $this->GetServices;
    }
    /**
     * Set GetServices value
     * @param bool $getServices
     * @return \Dpd\StructType\ReferenceDetailRequest
     */
    public function setGetServices($getServices = null)
    {
        // validation for constraint: boolean
        if (!is_null($getServices) && !is_bool($getServices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getServices, true), gettype($getServices)), __LINE__);
        }
        $this->GetServices = $getServices;
        return $this;
    }
    /**
     * Get GetLastTrace value
     * @return bool
     */
    public function getGetLastTrace()
    {
        return $this->GetLastTrace;
    }
    /**
     * Set GetLastTrace value
     * @param bool $getLastTrace
     * @return \Dpd\StructType\ReferenceDetailRequest
     */
    public function setGetLastTrace($getLastTrace = null)
    {
        // validation for constraint: boolean
        if (!is_null($getLastTrace) && !is_bool($getLastTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getLastTrace, true), gettype($getLastTrace)), __LINE__);
        }
        $this->GetLastTrace = $getLastTrace;
        return $this;
    }
    /**
     * Get Options value
     * @return \Dpd\StructType\Options|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \Dpd\StructType\Options $options
     * @return \Dpd\StructType\ReferenceDetailRequest
     */
    public function setOptions(\Dpd\StructType\Options $options = null)
    {
        $this->Options = $options;
        return $this;
    }
}
