<?php

namespace Dpd\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfServiceInfo extends AbstractStructArrayBase
{
    /**
     * The ServiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\StructType\ServiceInfo[]
     */
    public $ServiceInfo;
    /**
     * Constructor method for ArrayOfServiceInfo
     * @uses ArrayOfServiceInfo::setServiceInfo()
     * @param \Dpd\StructType\ServiceInfo[] $serviceInfo
     */
    public function __construct(array $serviceInfo = array())
    {
        $this
            ->setServiceInfo($serviceInfo);
    }
    /**
     * Get ServiceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\StructType\ServiceInfo[]|null
     */
    public function getServiceInfo()
    {
        return isset($this->ServiceInfo) ? $this->ServiceInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceInfoForArrayConstraintsFromSetServiceInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServiceInfoServiceInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceInfoServiceInfoItem instanceof \Dpd\StructType\ServiceInfo) {
                $invalidValues[] = is_object($arrayOfServiceInfoServiceInfoItem) ? get_class($arrayOfServiceInfoServiceInfoItem) : sprintf('%s(%s)', gettype($arrayOfServiceInfoServiceInfoItem), var_export($arrayOfServiceInfoServiceInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceInfo property can only contain items of type \Dpd\StructType\ServiceInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\ServiceInfo[] $serviceInfo
     * @return \Dpd\ArrayType\ArrayOfServiceInfo
     */
    public function setServiceInfo(array $serviceInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceInfoArrayErrorMessage = self::validateServiceInfoForArrayConstraintsFromSetServiceInfo($serviceInfo))) {
            throw new \InvalidArgumentException($serviceInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($serviceInfo) || (is_array($serviceInfo) && empty($serviceInfo))) {
            unset($this->ServiceInfo);
        } else {
            $this->ServiceInfo = $serviceInfo;
        }
        return $this;
    }
    /**
     * Add item to ServiceInfo value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\ServiceInfo $item
     * @return \Dpd\ArrayType\ArrayOfServiceInfo
     */
    public function addToServiceInfo(\Dpd\StructType\ServiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\ServiceInfo) {
            throw new \InvalidArgumentException(sprintf('The ServiceInfo property can only contain items of type \Dpd\StructType\ServiceInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Dpd\StructType\ServiceInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Dpd\StructType\ServiceInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Dpd\StructType\ServiceInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Dpd\StructType\ServiceInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Dpd\StructType\ServiceInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceInfo
     */
    public function getAttributeName()
    {
        return 'ServiceInfo';
    }
}
