<?php

namespace Dpd\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTracePhoto ArrayType
 * @subpackage Arrays
 */
class ArrayOfTracePhoto extends AbstractStructArrayBase
{
    /**
     * The TracePhoto
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\StructType\TracePhoto[]
     */
    public $TracePhoto;
    /**
     * Constructor method for ArrayOfTracePhoto
     * @uses ArrayOfTracePhoto::setTracePhoto()
     * @param \Dpd\StructType\TracePhoto[] $tracePhoto
     */
    public function __construct(array $tracePhoto = array())
    {
        $this
            ->setTracePhoto($tracePhoto);
    }
    /**
     * Get TracePhoto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\StructType\TracePhoto[]|null
     */
    public function getTracePhoto()
    {
        return isset($this->TracePhoto) ? $this->TracePhoto : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTracePhoto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTracePhoto method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTracePhotoForArrayConstraintsFromSetTracePhoto(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTracePhotoTracePhotoItem) {
            // validation for constraint: itemType
            if (!$arrayOfTracePhotoTracePhotoItem instanceof \Dpd\StructType\TracePhoto) {
                $invalidValues[] = is_object($arrayOfTracePhotoTracePhotoItem) ? get_class($arrayOfTracePhotoTracePhotoItem) : sprintf('%s(%s)', gettype($arrayOfTracePhotoTracePhotoItem), var_export($arrayOfTracePhotoTracePhotoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TracePhoto property can only contain items of type \Dpd\StructType\TracePhoto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TracePhoto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\TracePhoto[] $tracePhoto
     * @return \Dpd\ArrayType\ArrayOfTracePhoto
     */
    public function setTracePhoto(array $tracePhoto = array())
    {
        // validation for constraint: array
        if ('' !== ($tracePhotoArrayErrorMessage = self::validateTracePhotoForArrayConstraintsFromSetTracePhoto($tracePhoto))) {
            throw new \InvalidArgumentException($tracePhotoArrayErrorMessage, __LINE__);
        }
        if (is_null($tracePhoto) || (is_array($tracePhoto) && empty($tracePhoto))) {
            unset($this->TracePhoto);
        } else {
            $this->TracePhoto = $tracePhoto;
        }
        return $this;
    }
    /**
     * Add item to TracePhoto value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\TracePhoto $item
     * @return \Dpd\ArrayType\ArrayOfTracePhoto
     */
    public function addToTracePhoto(\Dpd\StructType\TracePhoto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\TracePhoto) {
            throw new \InvalidArgumentException(sprintf('The TracePhoto property can only contain items of type \Dpd\StructType\TracePhoto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TracePhoto[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Dpd\StructType\TracePhoto|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Dpd\StructType\TracePhoto|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Dpd\StructType\TracePhoto|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Dpd\StructType\TracePhoto|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Dpd\StructType\TracePhoto|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TracePhoto
     */
    public function getAttributeName()
    {
        return 'TracePhoto';
    }
}
