<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webtrace.dpd.fr/trace-service/Webtrace_Service.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webtrace.dpd.fr/trace-service/Webtrace_Service.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Dpd\ClassMap::get(),
);
/**
 * Samples for Is ServiceType
 */
$is = new \Dpd\ServiceType\Is($options);
/**
 * Sample call for isAlive operation/method
 */
if ($is->isAlive(new \Dpd\StructType\IsAlive()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \Dpd\ServiceType\Set($options);
$set->setSoapHeaderUserCredentials(new \Dpd\StructType\UserCredentials());
/**
 * Sample call for setAlive operation/method
 */
if ($set->setAlive(new \Dpd\StructType\SetAlive()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \Dpd\ServiceType\Verify($options);
$verify->setSoapHeaderVerifyUserCredentials(new \Dpd\StructType\VerifyUserCredentials());
/**
 * Sample call for VerifyConfiguration operation/method
 */
if ($verify->VerifyConfiguration(new \Dpd\StructType\VerifyConfiguration()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Dpd\ServiceType\Get($options);
$get->setSoapHeaderUserCredentials(new \Dpd\StructType\UserCredentials());
/**
 * Sample call for getInfo operation/method
 */
if ($get->getInfo(new \Dpd\StructType\GetInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShipmentTraceSingle operation/method
 */
if ($get->GetShipmentTraceSingle(new \Dpd\StructType\GetShipmentTraceSingle()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShipmentTrace operation/method
 */
if ($get->GetShipmentTrace(new \Dpd\StructType\GetShipmentTrace()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShipmentTraceByReference operation/method
 */
if ($get->GetShipmentTraceByReference(new \Dpd\StructType\GetShipmentTraceByReference()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastTrace operation/method
 */
if ($get->GetLastTrace(new \Dpd\StructType\GetLastTrace()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLastTraceBc operation/method
 */
if ($get->GetLastTraceBc(new \Dpd\StructType\GetLastTraceBc()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Run ServiceType
 */
$run = new \Dpd\ServiceType\Run($options);
$run->setSoapHeaderUserCredentials(new \Dpd\StructType\UserCredentials());
/**
 * Sample call for runAction operation/method
 */
if ($run->runAction(new \Dpd\StructType\RunAction()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
