<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatisticData StructType
 * @subpackage Structs
 */
class StatisticData extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Value;
    /**
     * The ValueName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValueName;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * Constructor method for StatisticData
     * @uses StatisticData::setValue()
     * @uses StatisticData::setValueName()
     * @uses StatisticData::setDate()
     * @param int $value
     * @param string $valueName
     * @param string $date
     */
    public function __construct($value = null, $valueName = null, $date = null)
    {
        $this
            ->setValue($value)
            ->setValueName($valueName)
            ->setDate($date);
    }
    /**
     * Get Value value
     * @return int
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \Dpd\StructType\StatisticData
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueName value
     * @return string|null
     */
    public function getValueName()
    {
        return $this->ValueName;
    }
    /**
     * Set ValueName value
     * @param string $valueName
     * @return \Dpd\StructType\StatisticData
     */
    public function setValueName($valueName = null)
    {
        // validation for constraint: string
        if (!is_null($valueName) && !is_string($valueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueName, true), gettype($valueName)), __LINE__);
        }
        $this->ValueName = $valueName;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Dpd\StructType\StatisticData
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
}
