<?php

namespace Dpd\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStatisticData ArrayType
 * @subpackage Arrays
 */
class ArrayOfStatisticData extends AbstractStructArrayBase
{
    /**
     * The StatisticData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\StructType\StatisticData[]
     */
    public $StatisticData;
    /**
     * Constructor method for ArrayOfStatisticData
     * @uses ArrayOfStatisticData::setStatisticData()
     * @param \Dpd\StructType\StatisticData[] $statisticData
     */
    public function __construct(array $statisticData = array())
    {
        $this
            ->setStatisticData($statisticData);
    }
    /**
     * Get StatisticData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\StructType\StatisticData[]|null
     */
    public function getStatisticData()
    {
        return isset($this->StatisticData) ? $this->StatisticData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatisticData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatisticData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatisticDataForArrayConstraintsFromSetStatisticData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStatisticDataStatisticDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfStatisticDataStatisticDataItem instanceof \Dpd\StructType\StatisticData) {
                $invalidValues[] = is_object($arrayOfStatisticDataStatisticDataItem) ? get_class($arrayOfStatisticDataStatisticDataItem) : sprintf('%s(%s)', gettype($arrayOfStatisticDataStatisticDataItem), var_export($arrayOfStatisticDataStatisticDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StatisticData property can only contain items of type \Dpd\StructType\StatisticData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatisticData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\StatisticData[] $statisticData
     * @return \Dpd\ArrayType\ArrayOfStatisticData
     */
    public function setStatisticData(array $statisticData = array())
    {
        // validation for constraint: array
        if ('' !== ($statisticDataArrayErrorMessage = self::validateStatisticDataForArrayConstraintsFromSetStatisticData($statisticData))) {
            throw new \InvalidArgumentException($statisticDataArrayErrorMessage, __LINE__);
        }
        if (is_null($statisticData) || (is_array($statisticData) && empty($statisticData))) {
            unset($this->StatisticData);
        } else {
            $this->StatisticData = $statisticData;
        }
        return $this;
    }
    /**
     * Add item to StatisticData value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\StatisticData $item
     * @return \Dpd\ArrayType\ArrayOfStatisticData
     */
    public function addToStatisticData(\Dpd\StructType\StatisticData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\StatisticData) {
            throw new \InvalidArgumentException(sprintf('The StatisticData property can only contain items of type \Dpd\StructType\StatisticData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StatisticData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Dpd\StructType\StatisticData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Dpd\StructType\StatisticData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Dpd\StructType\StatisticData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Dpd\StructType\StatisticData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Dpd\StructType\StatisticData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StatisticData
     */
    public function getAttributeName()
    {
        return 'StatisticData';
    }
}
