<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddStatisticDataRequest StructType
 * @subpackage Structs
 */
class AddStatisticDataRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientId;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Customer
     */
    public $Customer;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\ArrayType\ArrayOfStatisticData
     */
    public $Data;
    /**
     * Constructor method for AddStatisticDataRequest
     * @uses AddStatisticDataRequest::setClientId()
     * @uses AddStatisticDataRequest::setCustomer()
     * @uses AddStatisticDataRequest::setData()
     * @param string $clientId
     * @param \Dpd\StructType\Customer $customer
     * @param \Dpd\ArrayType\ArrayOfStatisticData $data
     */
    public function __construct($clientId = null, \Dpd\StructType\Customer $customer = null, \Dpd\ArrayType\ArrayOfStatisticData $data = null)
    {
        $this
            ->setClientId($clientId)
            ->setCustomer($customer)
            ->setData($data);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \Dpd\StructType\AddStatisticDataRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Dpd\StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Dpd\StructType\Customer $customer
     * @return \Dpd\StructType\AddStatisticDataRequest
     */
    public function setCustomer(\Dpd\StructType\Customer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Data value
     * @return \Dpd\ArrayType\ArrayOfStatisticData|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \Dpd\ArrayType\ArrayOfStatisticData $data
     * @return \Dpd\StructType\AddStatisticDataRequest
     */
    public function setData(\Dpd\ArrayType\ArrayOfStatisticData $data = null)
    {
        $this->Data = $data;
        return $this;
    }
}
