<?php

namespace Dpd\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBoolean ArrayType
 * @subpackage Arrays
 */
class ArrayOfBoolean extends AbstractStructArrayBase
{
    /**
     * The boolean
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var bool[]
     */
    public $boolean;
    /**
     * Constructor method for ArrayOfBoolean
     * @uses ArrayOfBoolean::setBoolean()
     * @param bool[] $boolean
     */
    public function __construct(array $boolean = array())
    {
        $this
            ->setBoolean($boolean);
    }
    /**
     * Get boolean value
     * @return bool[]|null
     */
    public function getBoolean()
    {
        return $this->boolean;
    }
    /**
     * This method is responsible for validating the values passed to the setBoolean method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBoolean method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBooleanForArrayConstraintsFromSetBoolean(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBooleanBooleanItem) {
            // validation for constraint: itemType
            if (!is_bool($arrayOfBooleanBooleanItem)) {
                $invalidValues[] = is_object($arrayOfBooleanBooleanItem) ? get_class($arrayOfBooleanBooleanItem) : sprintf('%s(%s)', gettype($arrayOfBooleanBooleanItem), var_export($arrayOfBooleanBooleanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The boolean property can only contain items of type boolean, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set boolean value
     * @throws \InvalidArgumentException
     * @param bool[] $boolean
     * @return \Dpd\ArrayType\ArrayOfBoolean
     */
    public function setBoolean(array $boolean = array())
    {
        // validation for constraint: array
        if ('' !== ($booleanArrayErrorMessage = self::validateBooleanForArrayConstraintsFromSetBoolean($boolean))) {
            throw new \InvalidArgumentException($booleanArrayErrorMessage, __LINE__);
        }
        $this->boolean = $boolean;
        return $this;
    }
    /**
     * Add item to boolean value
     * @throws \InvalidArgumentException
     * @param bool $item
     * @return \Dpd\ArrayType\ArrayOfBoolean
     */
    public function addToBoolean($item)
    {
        // validation for constraint: itemType
        if (!is_bool($item)) {
            throw new \InvalidArgumentException(sprintf('The boolean property can only contain items of type boolean, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->boolean[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return bool|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return bool|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return bool|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return bool|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return bool|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string boolean
     */
    public function getAttributeName()
    {
        return 'boolean';
    }
}
