<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionRequest StructType
 * @subpackage Structs
 */
class TransactionRequest extends AbstractStructBase
{
    /**
     * The AlternativeCenter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AlternativeCenter;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionId;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * Constructor method for TransactionRequest
     * @uses TransactionRequest::setAlternativeCenter()
     * @uses TransactionRequest::setTransactionId()
     * @uses TransactionRequest::setData()
     * @uses TransactionRequest::setLanguage()
     * @param int $alternativeCenter
     * @param string $transactionId
     * @param string $data
     * @param string $language
     */
    public function __construct($alternativeCenter = null, $transactionId = null, $data = null, $language = null)
    {
        $this
            ->setAlternativeCenter($alternativeCenter)
            ->setTransactionId($transactionId)
            ->setData($data)
            ->setLanguage($language);
    }
    /**
     * Get AlternativeCenter value
     * @return int
     */
    public function getAlternativeCenter()
    {
        return $this->AlternativeCenter;
    }
    /**
     * Set AlternativeCenter value
     * @param int $alternativeCenter
     * @return \Dpd\StructType\TransactionRequest
     */
    public function setAlternativeCenter($alternativeCenter = null)
    {
        // validation for constraint: int
        if (!is_null($alternativeCenter) && !(is_int($alternativeCenter) || ctype_digit($alternativeCenter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alternativeCenter, true), gettype($alternativeCenter)), __LINE__);
        }
        $this->AlternativeCenter = $alternativeCenter;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \Dpd\StructType\TransactionRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \Dpd\StructType\TransactionRequest
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Dpd\StructType\TransactionRequest
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
}
