<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WniosekONadanieUprawnienDoDanychPacjentaMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Wniosek o nadanie dostępu do dokumentacji medycznej pacjenta dla pracownika medycznego.
 * - type: WniosekONadanieUprawnienDoDanychPacjentaMT
 * @subpackage Structs
 */
class WniosekONadanieUprawnienDoDanychPacjentaMT extends AbstractStructBase
{
    /**
     * The identyfikatorPacjenta
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator pacjenta, którego dotyczy wniosek. W polu root przekazywany jest typ identyfikatora, a w polu extension konkretna wartość dla danego typu. Np. dla numeru PESEL, w polu root należy podać
     * 2.16.840.1.113883.3.4424.1.1.616, a w polu extension konkretny numer PESEL.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\IdentyfikatorUslugobiorcyOIDMT
     */
    public $identyfikatorPacjenta;
    /**
     * The identyfikatorOsobyAutoryzujacej
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator osoby autoryzującej wniosek - pacjenta, jego opiekuna lub pełnomocnika. W polu root przekazywany jest typ identyfikatora, a w polu extension konkretna wartość dla danego typu. Np. dla numeru PESEL, w polu root
     * należy podać 2.16.840.1.113883.3.4424.1.1.616, a w polu extension konkretny numer PESEL.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\IdentyfikatorUslugobiorcyOIDMT
     */
    public $identyfikatorOsobyAutoryzujacej;
    /**
     * Constructor method for WniosekONadanieUprawnienDoDanychPacjentaMT
     * @uses WniosekONadanieUprawnienDoDanychPacjentaMT::setIdentyfikatorPacjenta()
     * @uses WniosekONadanieUprawnienDoDanychPacjentaMT::setIdentyfikatorOsobyAutoryzujacej()
     * @param \StructType\IdentyfikatorUslugobiorcyOIDMT $identyfikatorPacjenta
     * @param \StructType\IdentyfikatorUslugobiorcyOIDMT $identyfikatorOsobyAutoryzujacej
     */
    public function __construct(\StructType\IdentyfikatorUslugobiorcyOIDMT $identyfikatorPacjenta = null, \StructType\IdentyfikatorUslugobiorcyOIDMT $identyfikatorOsobyAutoryzujacej = null)
    {
        $this
            ->setIdentyfikatorPacjenta($identyfikatorPacjenta)
            ->setIdentyfikatorOsobyAutoryzujacej($identyfikatorOsobyAutoryzujacej);
    }
    /**
     * Get identyfikatorPacjenta value
     * @return \StructType\IdentyfikatorUslugobiorcyOIDMT
     */
    public function getIdentyfikatorPacjenta()
    {
        return $this->identyfikatorPacjenta;
    }
    /**
     * Set identyfikatorPacjenta value
     * @param \StructType\IdentyfikatorUslugobiorcyOIDMT $identyfikatorPacjenta
     * @return \StructType\WniosekONadanieUprawnienDoDanychPacjentaMT
     */
    public function setIdentyfikatorPacjenta(\StructType\IdentyfikatorUslugobiorcyOIDMT $identyfikatorPacjenta = null)
    {
        $this->identyfikatorPacjenta = $identyfikatorPacjenta;
        return $this;
    }
    /**
     * Get identyfikatorOsobyAutoryzujacej value
     * @return \StructType\IdentyfikatorUslugobiorcyOIDMT
     */
    public function getIdentyfikatorOsobyAutoryzujacej()
    {
        return $this->identyfikatorOsobyAutoryzujacej;
    }
    /**
     * Set identyfikatorOsobyAutoryzujacej value
     * @param \StructType\IdentyfikatorUslugobiorcyOIDMT $identyfikatorOsobyAutoryzujacej
     * @return \StructType\WniosekONadanieUprawnienDoDanychPacjentaMT
     */
    public function setIdentyfikatorOsobyAutoryzujacej(\StructType\IdentyfikatorUslugobiorcyOIDMT $identyfikatorOsobyAutoryzujacej = null)
    {
        $this->identyfikatorOsobyAutoryzujacej = $identyfikatorOsobyAutoryzujacej;
        return $this;
    }
}
