<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoryzacjaDostepuDokMedMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Autoryzacja wniosku o nadanie dostępu do dokumentacji medycznej pacjenta dla pracownika medycznego.
 * @subpackage Structs
 */
class AutoryzacjaDostepuDokMedMT extends AbstractStructBase
{
    /**
     * The idWniosku
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator wniosku nadany przez System P1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idWniosku;
    /**
     * The kodAutoryzacji
     * Meta information extracted from the WSDL
     * - documentation: Kod autoryzacyjny przesłany do osoby autoryzującej wniosek.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kodAutoryzacji;
    /**
     * Constructor method for AutoryzacjaDostepuDokMedMT
     * @uses AutoryzacjaDostepuDokMedMT::setIdWniosku()
     * @uses AutoryzacjaDostepuDokMedMT::setKodAutoryzacji()
     * @param string $idWniosku
     * @param string $kodAutoryzacji
     */
    public function __construct($idWniosku = null, $kodAutoryzacji = null)
    {
        $this
            ->setIdWniosku($idWniosku)
            ->setKodAutoryzacji($kodAutoryzacji);
    }
    /**
     * Get idWniosku value
     * @return string
     */
    public function getIdWniosku()
    {
        return $this->idWniosku;
    }
    /**
     * Set idWniosku value
     * @param string $idWniosku
     * @return \StructType\AutoryzacjaDostepuDokMedMT
     */
    public function setIdWniosku($idWniosku = null)
    {
        // validation for constraint: string
        if (!is_null($idWniosku) && !is_string($idWniosku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idWniosku, true), gettype($idWniosku)), __LINE__);
        }
        $this->idWniosku = $idWniosku;
        return $this;
    }
    /**
     * Get kodAutoryzacji value
     * @return string
     */
    public function getKodAutoryzacji()
    {
        return $this->kodAutoryzacji;
    }
    /**
     * Set kodAutoryzacji value
     * @param string $kodAutoryzacji
     * @return \StructType\AutoryzacjaDostepuDokMedMT
     */
    public function setKodAutoryzacji($kodAutoryzacji = null)
    {
        // validation for constraint: string
        if (!is_null($kodAutoryzacji) && !is_string($kodAutoryzacji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodAutoryzacji, true), gettype($kodAutoryzacji)), __LINE__);
        }
        $this->kodAutoryzacji = $kodAutoryzacji;
        return $this;
    }
}
