<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KanalyKomunikacjiUslugobiorcyMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Określa aktywne kanały komunikacji usługobiorcy.
 * @subpackage Structs
 */
class KanalyKomunikacjiUslugobiorcyMT extends AbstractStructBase
{
    /**
     * The czyPowiadomieniaEmail
     * Meta information extracted from the WSDL
     * - documentation: Określa czy jest aktywny kanał komunikacji email skonfigurowany przez usługobiorcę w IKP.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $czyPowiadomieniaEmail;
    /**
     * The czyPowiadomieniaSMS
     * Meta information extracted from the WSDL
     * - documentation: Określa czy jest aktywny kanał komunikacji SMS skonfigurowany przez usługobiorcę w IKP.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $czyPowiadomieniaSMS;
    /**
     * The czyKontoIKP
     * Meta information extracted from the WSDL
     * - documentation: Określa czy usługobiorca ma aktywne konto w IKP.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $czyKontoIKP;
    /**
     * Constructor method for KanalyKomunikacjiUslugobiorcyMT
     * @uses KanalyKomunikacjiUslugobiorcyMT::setCzyPowiadomieniaEmail()
     * @uses KanalyKomunikacjiUslugobiorcyMT::setCzyPowiadomieniaSMS()
     * @uses KanalyKomunikacjiUslugobiorcyMT::setCzyKontoIKP()
     * @param bool $czyPowiadomieniaEmail
     * @param bool $czyPowiadomieniaSMS
     * @param bool $czyKontoIKP
     */
    public function __construct($czyPowiadomieniaEmail = null, $czyPowiadomieniaSMS = null, $czyKontoIKP = null)
    {
        $this
            ->setCzyPowiadomieniaEmail($czyPowiadomieniaEmail)
            ->setCzyPowiadomieniaSMS($czyPowiadomieniaSMS)
            ->setCzyKontoIKP($czyKontoIKP);
    }
    /**
     * Get czyPowiadomieniaEmail value
     * @return bool
     */
    public function getCzyPowiadomieniaEmail()
    {
        return $this->czyPowiadomieniaEmail;
    }
    /**
     * Set czyPowiadomieniaEmail value
     * @param bool $czyPowiadomieniaEmail
     * @return \StructType\KanalyKomunikacjiUslugobiorcyMT
     */
    public function setCzyPowiadomieniaEmail($czyPowiadomieniaEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($czyPowiadomieniaEmail) && !is_bool($czyPowiadomieniaEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($czyPowiadomieniaEmail, true), gettype($czyPowiadomieniaEmail)), __LINE__);
        }
        $this->czyPowiadomieniaEmail = $czyPowiadomieniaEmail;
        return $this;
    }
    /**
     * Get czyPowiadomieniaSMS value
     * @return bool
     */
    public function getCzyPowiadomieniaSMS()
    {
        return $this->czyPowiadomieniaSMS;
    }
    /**
     * Set czyPowiadomieniaSMS value
     * @param bool $czyPowiadomieniaSMS
     * @return \StructType\KanalyKomunikacjiUslugobiorcyMT
     */
    public function setCzyPowiadomieniaSMS($czyPowiadomieniaSMS = null)
    {
        // validation for constraint: boolean
        if (!is_null($czyPowiadomieniaSMS) && !is_bool($czyPowiadomieniaSMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($czyPowiadomieniaSMS, true), gettype($czyPowiadomieniaSMS)), __LINE__);
        }
        $this->czyPowiadomieniaSMS = $czyPowiadomieniaSMS;
        return $this;
    }
    /**
     * Get czyKontoIKP value
     * @return bool
     */
    public function getCzyKontoIKP()
    {
        return $this->czyKontoIKP;
    }
    /**
     * Set czyKontoIKP value
     * @param bool $czyKontoIKP
     * @return \StructType\KanalyKomunikacjiUslugobiorcyMT
     */
    public function setCzyKontoIKP($czyKontoIKP = null)
    {
        // validation for constraint: boolean
        if (!is_null($czyKontoIKP) && !is_bool($czyKontoIKP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($czyKontoIKP, true), gettype($czyKontoIKP)), __LINE__);
        }
        $this->czyKontoIKP = $czyKontoIKP;
        return $this;
    }
}
