<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Odczyt ServiceType
 * @subpackage Services
 */
class Odczyt extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(\StructType\KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20180509', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * odczytKanalowKomunikacjiUslugobiorcy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja umożliwia odczyt informacji o typie zdefiniowanych kanałów komunikacji jakie posiada Usługobiorca. | Operacja umożliwia odczyt informacji o typie zdefiniowanych kanałów komunikacji jakie posiada Usługobiorca.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OdczytKanalowKomunikacjiUslugobiorcyRequest $odczytKanalowKomunikacjiUslugobiorcy
     * @return \StructType\OdczytKanalowKomunikacjiUslugobiorcyResponse|bool
     */
    public function odczytKanalowKomunikacjiUslugobiorcy(\StructType\OdczytKanalowKomunikacjiUslugobiorcyRequest $odczytKanalowKomunikacjiUslugobiorcy)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytKanalowKomunikacjiUslugobiorcy($odczytKanalowKomunikacjiUslugobiorcy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OdczytKanalowKomunikacjiUslugobiorcyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
