<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zloz ServiceType
 * @subpackage Services
 */
class Zloz extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(\StructType\KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20180509', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * zlozWniosekONadanieUprawnienDoDanychPacjenta
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja umożliwia złożenie wniosku o nadanie uprawnień dostępu do danych medycznych pacjenta. | Operacja umożliwia złożenie wniosku o nadanie uprawnień dostępu do danych medycznych pacjenta.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZlozWniosekONadanieUprawnienDoDanychPacjentaRequest $zlozWniosekONadanieUprawnienDoDanychPacjenta
     * @return \StructType\ZlozWniosekONadanieUprawnienDoDanychPacjentaResponse|bool
     */
    public function zlozWniosekONadanieUprawnienDoDanychPacjenta(\StructType\ZlozWniosekONadanieUprawnienDoDanychPacjentaRequest $zlozWniosekONadanieUprawnienDoDanychPacjenta)
    {
        try {
            $this->setResult($this->getSoapClient()->zlozWniosekONadanieUprawnienDoDanychPacjenta($zlozWniosekONadanieUprawnienDoDanychPacjenta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZlozWniosekONadanieUprawnienDoDanychPacjentaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
