<?php

namespace JonathanCosta\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for Order
     * @uses Order::setStatus()
     * @uses Order::setOrderId()
     * @uses Order::setMessage()
     * @param string $status
     * @param string $orderId
     * @param string $message
     */
    public function __construct($status = null, $orderId = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setOrderId($orderId)
            ->setMessage($message);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \JonathanCosta\EnumType\StatusCode::valueIsValid()
     * @uses \JonathanCosta\EnumType\StatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \JonathanCosta\StructType\Order
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\JonathanCosta\EnumType\StatusCode::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \JonathanCosta\EnumType\StatusCode', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \JonathanCosta\EnumType\StatusCode::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \JonathanCosta\StructType\Order
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \JonathanCosta\StructType\Order
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
