<?php

namespace JonathanCosta\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetOrderAsReturned
     * Meta information extracted from the WSDL
     * - documentation: Avisa ao ClearSale para que não retorne mais o pedido na chamada do Método GetReturnAnalysis | Avisa ao ClearSale para que não retorne mais o pedido na chamada do Método GetReturnAnalysis | Avisa ao ClearSale para que não
     * retorne mais o pedido na chamada do Método GetReturnAnalysis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\SetOrderAsReturned $parameters
     * @return \JonathanCosta\StructType\SetOrderAsReturnedResponse|bool
     */
    public function SetOrderAsReturned(\JonathanCosta\StructType\SetOrderAsReturned $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderAsReturned($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \JonathanCosta\StructType\SetOrderAsReturnedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
