<?php

namespace JonathanCosta\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Order ServiceType
 * @subpackage Services
 */
class Order extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OrderChargeBack
     * Meta information extracted from the WSDL
     * - documentation: Marca o pedido como ChargeBack | Marca o pedido como ChargeBack | Marca o pedido como ChargeBack
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\OrderChargeBack $parameters
     * @return \JonathanCosta\StructType\OrderChargeBackResponse|bool
     */
    public function OrderChargeBack(\JonathanCosta\StructType\OrderChargeBack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderChargeBack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OrderChargeBackByNsu
     * Meta information extracted from the WSDL
     * - documentation: Marca o pedido como ChargeBack através do NSU | Marca o pedido como ChargeBack através do NSU | Marca o pedido como ChargeBack através do NSU
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\OrderChargeBackByNsu $parameters
     * @return \JonathanCosta\StructType\OrderChargeBackByNsuResponse|bool
     */
    public function OrderChargeBackByNsu(\JonathanCosta\StructType\OrderChargeBackByNsu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderChargeBackByNsu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \JonathanCosta\StructType\OrderChargeBackByNsuResponse|\JonathanCosta\StructType\OrderChargeBackResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
