<?php

namespace JonathanCosta\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for StatusCode EnumType
 * @subpackage Enumerations
 */
class StatusCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Invalido'
     * @return string 'Invalido'
     */
    const VALUE_INVALIDO = 'Invalido';
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'UserNotFound'
     * @return string 'UserNotFound'
     */
    const VALUE_USER_NOT_FOUND = 'UserNotFound';
    /**
     * Constant for value 'XMLValidation'
     * @return string 'XMLValidation'
     */
    const VALUE_XMLVALIDATION = 'XMLValidation';
    /**
     * Constant for value 'XMLTransform'
     * @return string 'XMLTransform'
     */
    const VALUE_XMLTRANSFORM = 'XMLTransform';
    /**
     * Constant for value 'UnexpectedError'
     * @return string 'UnexpectedError'
     */
    const VALUE_UNEXPECTED_ERROR = 'UnexpectedError';
    /**
     * Constant for value 'OrderExist'
     * @return string 'OrderExist'
     */
    const VALUE_ORDER_EXIST = 'OrderExist';
    /**
     * Constant for value 'InputPlugin'
     * @return string 'InputPlugin'
     */
    const VALUE_INPUT_PLUGIN = 'InputPlugin';
    /**
     * Constant for value 'OutputPlugin'
     * @return string 'OutputPlugin'
     */
    const VALUE_OUTPUT_PLUGIN = 'OutputPlugin';
    /**
     * Constant for value 'PaymentTypeNotFound'
     * @return string 'PaymentTypeNotFound'
     */
    const VALUE_PAYMENT_TYPE_NOT_FOUND = 'PaymentTypeNotFound';
    /**
     * Constant for value 'CardTypeNotFound'
     * @return string 'CardTypeNotFound'
     */
    const VALUE_CARD_TYPE_NOT_FOUND = 'CardTypeNotFound';
    /**
     * Constant for value 'StatusNotPermited'
     * @return string 'StatusNotPermited'
     */
    const VALUE_STATUS_NOT_PERMITED = 'StatusNotPermited';
    /**
     * Constant for value 'OrderNotFound'
     * @return string 'OrderNotFound'
     */
    const VALUE_ORDER_NOT_FOUND = 'OrderNotFound';
    /**
     * Constant for value 'OKComErros'
     * @return string 'OKComErros'
     */
    const VALUE_OKCOM_ERROS = 'OKComErros';
    /**
     * Constant for value 'FilaNaoEncontrada'
     * @return string 'FilaNaoEncontrada'
     */
    const VALUE_FILA_NAO_ENCONTRADA = 'FilaNaoEncontrada';
    /**
     * Constant for value 'InvalidRequest'
     * @return string 'InvalidRequest'
     */
    const VALUE_INVALID_REQUEST = 'InvalidRequest';
    /**
     * Constant for value 'PaymentNotFound'
     * @return string 'PaymentNotFound'
     */
    const VALUE_PAYMENT_NOT_FOUND = 'PaymentNotFound';
    /**
     * Constant for value 'NsuExists'
     * @return string 'NsuExists'
     */
    const VALUE_NSU_EXISTS = 'NsuExists';
    /**
     * Constant for value 'NsuNotFound'
     * @return string 'NsuNotFound'
     */
    const VALUE_NSU_NOT_FOUND = 'NsuNotFound';
    /**
     * Constant for value 'NsuDuplicate'
     * @return string 'NsuDuplicate'
     */
    const VALUE_NSU_DUPLICATE = 'NsuDuplicate';
    /**
     * Constant for value 'QuizInactive'
     * @return string 'QuizInactive'
     */
    const VALUE_QUIZ_INACTIVE = 'QuizInactive';
    /**
     * Constant for value 'GenericFieldNotFound'
     * @return string 'GenericFieldNotFound'
     */
    const VALUE_GENERIC_FIELD_NOT_FOUND = 'GenericFieldNotFound';
    /**
     * Constant for value 'QuizNotFound'
     * @return string 'QuizNotFound'
     */
    const VALUE_QUIZ_NOT_FOUND = 'QuizNotFound';
    /**
     * Constant for value 'UserNotAuthorized'
     * @return string 'UserNotAuthorized'
     */
    const VALUE_USER_NOT_AUTHORIZED = 'UserNotAuthorized';
    /**
     * Constant for value 'OrderWithoutDiagnostics'
     * @return string 'OrderWithoutDiagnostics'
     */
    const VALUE_ORDER_WITHOUT_DIAGNOSTICS = 'OrderWithoutDiagnostics';
    /**
     * Constant for value 'ProductUnavailable'
     * @return string 'ProductUnavailable'
     */
    const VALUE_PRODUCT_UNAVAILABLE = 'ProductUnavailable';
    /**
     * Return allowed values
     * @uses self::VALUE_INVALIDO
     * @uses self::VALUE_OK
     * @uses self::VALUE_USER_NOT_FOUND
     * @uses self::VALUE_XMLVALIDATION
     * @uses self::VALUE_XMLTRANSFORM
     * @uses self::VALUE_UNEXPECTED_ERROR
     * @uses self::VALUE_ORDER_EXIST
     * @uses self::VALUE_INPUT_PLUGIN
     * @uses self::VALUE_OUTPUT_PLUGIN
     * @uses self::VALUE_PAYMENT_TYPE_NOT_FOUND
     * @uses self::VALUE_CARD_TYPE_NOT_FOUND
     * @uses self::VALUE_STATUS_NOT_PERMITED
     * @uses self::VALUE_ORDER_NOT_FOUND
     * @uses self::VALUE_OKCOM_ERROS
     * @uses self::VALUE_FILA_NAO_ENCONTRADA
     * @uses self::VALUE_INVALID_REQUEST
     * @uses self::VALUE_PAYMENT_NOT_FOUND
     * @uses self::VALUE_NSU_EXISTS
     * @uses self::VALUE_NSU_NOT_FOUND
     * @uses self::VALUE_NSU_DUPLICATE
     * @uses self::VALUE_QUIZ_INACTIVE
     * @uses self::VALUE_GENERIC_FIELD_NOT_FOUND
     * @uses self::VALUE_QUIZ_NOT_FOUND
     * @uses self::VALUE_USER_NOT_AUTHORIZED
     * @uses self::VALUE_ORDER_WITHOUT_DIAGNOSTICS
     * @uses self::VALUE_PRODUCT_UNAVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INVALIDO,
            self::VALUE_OK,
            self::VALUE_USER_NOT_FOUND,
            self::VALUE_XMLVALIDATION,
            self::VALUE_XMLTRANSFORM,
            self::VALUE_UNEXPECTED_ERROR,
            self::VALUE_ORDER_EXIST,
            self::VALUE_INPUT_PLUGIN,
            self::VALUE_OUTPUT_PLUGIN,
            self::VALUE_PAYMENT_TYPE_NOT_FOUND,
            self::VALUE_CARD_TYPE_NOT_FOUND,
            self::VALUE_STATUS_NOT_PERMITED,
            self::VALUE_ORDER_NOT_FOUND,
            self::VALUE_OKCOM_ERROS,
            self::VALUE_FILA_NAO_ENCONTRADA,
            self::VALUE_INVALID_REQUEST,
            self::VALUE_PAYMENT_NOT_FOUND,
            self::VALUE_NSU_EXISTS,
            self::VALUE_NSU_NOT_FOUND,
            self::VALUE_NSU_DUPLICATE,
            self::VALUE_QUIZ_INACTIVE,
            self::VALUE_GENERIC_FIELD_NOT_FOUND,
            self::VALUE_QUIZ_NOT_FOUND,
            self::VALUE_USER_NOT_AUTHORIZED,
            self::VALUE_ORDER_WITHOUT_DIAGNOSTICS,
            self::VALUE_PRODUCT_UNAVAILABLE,
        );
    }
}
