<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://homologacao.clearsale.com.br/integracaov2/Service.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://homologacao.clearsale.com.br/integracaov2/Service.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \JonathanCosta\ClassMap::get(),
);
/**
 * Samples for Send ServiceType
 */
$send = new \JonathanCosta\ServiceType\Send($options);
/**
 * Sample call for SendOrders2 operation/method
 */
if ($send->SendOrders2(new \JonathanCosta\StructType\SendOrders2()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendOrders operation/method
 */
if ($send->SendOrders(new \JonathanCosta\StructType\SendOrders()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendExternalStatus operation/method
 */
if ($send->SendExternalStatus(new \JonathanCosta\StructType\SendExternalStatus()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \JonathanCosta\ServiceType\Get($options);
/**
 * Sample call for GetPackageStatus operation/method
 */
if ($get->GetPackageStatus(new \JonathanCosta\StructType\GetPackageStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderStatus operation/method
 */
if ($get->GetOrderStatus(new \JonathanCosta\StructType\GetOrderStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrdersStatus operation/method
 */
if ($get->GetOrdersStatus(new \JonathanCosta\StructType\GetOrdersStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReturnAnalysis operation/method
 */
if ($get->GetReturnAnalysis(new \JonathanCosta\StructType\GetReturnAnalysis()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAnalystComments operation/method
 */
if ($get->GetAnalystComments(new \JonathanCosta\StructType\GetAnalystComments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuizURL operation/method
 */
if ($get->GetQuizURL(new \JonathanCosta\StructType\GetQuizURL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPackageStatusCustom operation/method
 */
if ($get->GetPackageStatusCustom(new \JonathanCosta\StructType\GetPackageStatusCustom()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \JonathanCosta\ServiceType\Set($options);
/**
 * Sample call for SetOrderAsReturned operation/method
 */
if ($set->SetOrderAsReturned(new \JonathanCosta\StructType\SetOrderAsReturned()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \JonathanCosta\ServiceType\Order($options);
/**
 * Sample call for OrderChargeBack operation/method
 */
if ($order->OrderChargeBack(new \JonathanCosta\StructType\OrderChargeBack()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Sample call for OrderChargeBackByNsu operation/method
 */
if ($order->OrderChargeBackByNsu(new \JonathanCosta\StructType\OrderChargeBackByNsu()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Submit ServiceType
 */
$submit = new \JonathanCosta\ServiceType\Submit($options);
/**
 * Sample call for SubmitInfo operation/method
 */
if ($submit->SubmitInfo(new \JonathanCosta\StructType\SubmitInfo()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \JonathanCosta\ServiceType\Check($options);
/**
 * Sample call for CheckOrderStatus operation/method
 */
if ($check->CheckOrderStatus(new \JonathanCosta\StructType\CheckOrderStatus()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
