<?php

namespace JonathanCosta\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionStatus StructType
 * @subpackage Structs
 */
class TransactionStatus extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusCode;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for TransactionStatus
     * @uses TransactionStatus::setStatusCode()
     * @uses TransactionStatus::setMessage()
     * @param string $statusCode
     * @param string $message
     */
    public function __construct($statusCode = null, $message = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setMessage($message);
    }
    /**
     * Get StatusCode value
     * @return string
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @uses \JonathanCosta\EnumType\StatusCode::valueIsValid()
     * @uses \JonathanCosta\EnumType\StatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusCode
     * @return \JonathanCosta\StructType\TransactionStatus
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: enumeration
        if (!\JonathanCosta\EnumType\StatusCode::valueIsValid($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \JonathanCosta\EnumType\StatusCode', is_array($statusCode) ? implode(', ', $statusCode) : var_export($statusCode, true), implode(', ', \JonathanCosta\EnumType\StatusCode::getValidValues())), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \JonathanCosta\StructType\TransactionStatus
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
