<?php

namespace JonathanCosta\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendOrders2 StructType
 * @subpackage Structs
 */
class SendOrders2 extends AbstractStructBase
{
    /**
     * The entityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $entityCode;
    /**
     * The pedidos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pedidos;
    /**
     * Constructor method for SendOrders2
     * @uses SendOrders2::setEntityCode()
     * @uses SendOrders2::setPedidos()
     * @param string $entityCode
     * @param string $pedidos
     */
    public function __construct($entityCode = null, $pedidos = null)
    {
        $this
            ->setEntityCode($entityCode)
            ->setPedidos($pedidos);
    }
    /**
     * Get entityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->entityCode;
    }
    /**
     * Set entityCode value
     * @param string $entityCode
     * @return \JonathanCosta\StructType\SendOrders2
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->entityCode = $entityCode;
        return $this;
    }
    /**
     * Get pedidos value
     * @return string|null
     */
    public function getPedidos()
    {
        return $this->pedidos;
    }
    /**
     * Set pedidos value
     * @param string $pedidos
     * @return \JonathanCosta\StructType\SendOrders2
     */
    public function setPedidos($pedidos = null)
    {
        // validation for constraint: string
        if (!is_null($pedidos) && !is_string($pedidos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pedidos, true), gettype($pedidos)), __LINE__);
        }
        $this->pedidos = $pedidos;
        return $this;
    }
}
