<?php

namespace JonathanCosta\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderChargeBack StructType
 * @subpackage Structs
 */
class OrderChargeBack extends AbstractStructBase
{
    /**
     * The entityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $entityCode;
    /**
     * The Xml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Xml;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * Constructor method for OrderChargeBack
     * @uses OrderChargeBack::setEntityCode()
     * @uses OrderChargeBack::setXml()
     * @uses OrderChargeBack::setNote()
     * @param string $entityCode
     * @param string $xml
     * @param string $note
     */
    public function __construct($entityCode = null, $xml = null, $note = null)
    {
        $this
            ->setEntityCode($entityCode)
            ->setXml($xml)
            ->setNote($note);
    }
    /**
     * Get entityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->entityCode;
    }
    /**
     * Set entityCode value
     * @param string $entityCode
     * @return \JonathanCosta\StructType\OrderChargeBack
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->entityCode = $entityCode;
        return $this;
    }
    /**
     * Get Xml value
     * @return string|null
     */
    public function getXml()
    {
        return $this->Xml;
    }
    /**
     * Set Xml value
     * @param string $xml
     * @return \JonathanCosta\StructType\OrderChargeBack
     */
    public function setXml($xml = null)
    {
        // validation for constraint: string
        if (!is_null($xml) && !is_string($xml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xml, true), gettype($xml)), __LINE__);
        }
        $this->Xml = $xml;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \JonathanCosta\StructType\OrderChargeBack
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
}
