<?php

namespace JonathanCosta\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendOrders2
     * Meta information extracted from the WSDL
     * - documentation: Método para envio de pedidos (igual ao SendOrders porém com o nome parametro (XML) diferente (PEDIDOS)) | Método para envio de pedidos (igual ao SendOrders porém com o nome parametro (XML) diferente (PEDIDOS)) | Método para
     * envio de pedidos (igual ao SendOrders porém com o nome parametro (XML) diferente (PEDIDOS))
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\SendOrders2 $parameters
     * @return \JonathanCosta\StructType\SendOrders2Response|bool
     */
    public function SendOrders2(\JonathanCosta\StructType\SendOrders2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendOrders2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendOrders
     * Meta information extracted from the WSDL
     * - documentation: Método para envio de pedidos | Método para envio de pedidos | Método para envio de pedidos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\SendOrders $parameters
     * @return \JonathanCosta\StructType\SendOrdersResponse|bool
     */
    public function SendOrders(\JonathanCosta\StructType\SendOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendExternalStatus
     * Meta information extracted from the WSDL
     * - documentation: Método para envio de Status Externo | Método para envio de Status Externo | Método para envio de Status Externo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\SendExternalStatus $parameters
     * @return \JonathanCosta\StructType\SendExternalStatusResponse|bool
     */
    public function SendExternalStatus(\JonathanCosta\StructType\SendExternalStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendExternalStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \JonathanCosta\StructType\SendExternalStatusResponse|\JonathanCosta\StructType\SendOrders2Response|\JonathanCosta\StructType\SendOrdersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
