<?php

namespace JonathanCosta\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPackageStatus StructType
 * @subpackage Structs
 */
class GetPackageStatus extends AbstractStructBase
{
    /**
     * The entityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $entityCode;
    /**
     * The packageID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packageID;
    /**
     * Constructor method for GetPackageStatus
     * @uses GetPackageStatus::setEntityCode()
     * @uses GetPackageStatus::setPackageID()
     * @param string $entityCode
     * @param string $packageID
     */
    public function __construct($entityCode = null, $packageID = null)
    {
        $this
            ->setEntityCode($entityCode)
            ->setPackageID($packageID);
    }
    /**
     * Get entityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->entityCode;
    }
    /**
     * Set entityCode value
     * @param string $entityCode
     * @return \JonathanCosta\StructType\GetPackageStatus
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->entityCode = $entityCode;
        return $this;
    }
    /**
     * Get packageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->packageID;
    }
    /**
     * Set packageID value
     * @param string $packageID
     * @return \JonathanCosta\StructType\GetPackageStatus
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageID, true), gettype($packageID)), __LINE__);
        }
        $this->packageID = $packageID;
        return $this;
    }
}
