<?php

namespace JonathanCosta\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderChargeBackByNsu StructType
 * @subpackage Structs
 */
class OrderChargeBackByNsu extends AbstractStructBase
{
    /**
     * The cartaoBandeira
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $cartaoBandeira;
    /**
     * The entityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $entityCode;
    /**
     * The nsu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nsu;
    /**
     * The conciliadorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $conciliadorCode;
    /**
     * Constructor method for OrderChargeBackByNsu
     * @uses OrderChargeBackByNsu::setCartaoBandeira()
     * @uses OrderChargeBackByNsu::setEntityCode()
     * @uses OrderChargeBackByNsu::setNsu()
     * @uses OrderChargeBackByNsu::setConciliadorCode()
     * @param int $cartaoBandeira
     * @param string $entityCode
     * @param string $nsu
     * @param string $conciliadorCode
     */
    public function __construct($cartaoBandeira = null, $entityCode = null, $nsu = null, $conciliadorCode = null)
    {
        $this
            ->setCartaoBandeira($cartaoBandeira)
            ->setEntityCode($entityCode)
            ->setNsu($nsu)
            ->setConciliadorCode($conciliadorCode);
    }
    /**
     * Get cartaoBandeira value
     * @return int
     */
    public function getCartaoBandeira()
    {
        return $this->cartaoBandeira;
    }
    /**
     * Set cartaoBandeira value
     * @param int $cartaoBandeira
     * @return \JonathanCosta\StructType\OrderChargeBackByNsu
     */
    public function setCartaoBandeira($cartaoBandeira = null)
    {
        // validation for constraint: int
        if (!is_null($cartaoBandeira) && !(is_int($cartaoBandeira) || ctype_digit($cartaoBandeira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cartaoBandeira, true), gettype($cartaoBandeira)), __LINE__);
        }
        $this->cartaoBandeira = $cartaoBandeira;
        return $this;
    }
    /**
     * Get entityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->entityCode;
    }
    /**
     * Set entityCode value
     * @param string $entityCode
     * @return \JonathanCosta\StructType\OrderChargeBackByNsu
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->entityCode = $entityCode;
        return $this;
    }
    /**
     * Get nsu value
     * @return string|null
     */
    public function getNsu()
    {
        return $this->nsu;
    }
    /**
     * Set nsu value
     * @param string $nsu
     * @return \JonathanCosta\StructType\OrderChargeBackByNsu
     */
    public function setNsu($nsu = null)
    {
        // validation for constraint: string
        if (!is_null($nsu) && !is_string($nsu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nsu, true), gettype($nsu)), __LINE__);
        }
        $this->nsu = $nsu;
        return $this;
    }
    /**
     * Get conciliadorCode value
     * @return string|null
     */
    public function getConciliadorCode()
    {
        return $this->conciliadorCode;
    }
    /**
     * Set conciliadorCode value
     * @param string $conciliadorCode
     * @return \JonathanCosta\StructType\OrderChargeBackByNsu
     */
    public function setConciliadorCode($conciliadorCode = null)
    {
        // validation for constraint: string
        if (!is_null($conciliadorCode) && !is_string($conciliadorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conciliadorCode, true), gettype($conciliadorCode)), __LINE__);
        }
        $this->conciliadorCode = $conciliadorCode;
        return $this;
    }
}
