<?php

namespace JonathanCosta\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetPackageStatus
     * Meta information extracted from the WSDL
     * - documentation: Retorna o status de todos os pedidos em um pacote | Retorna o status de todos os pedidos em um pacote | Retorna o status de todos os pedidos em um pacote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\GetPackageStatus $parameters
     * @return \JonathanCosta\StructType\GetPackageStatusResponse|bool
     */
    public function GetPackageStatus(\JonathanCosta\StructType\GetPackageStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPackageStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderStatus
     * Meta information extracted from the WSDL
     * - documentation: Retorna o status de um pedido | Retorna o status de um pedido | Retorna o status de um pedido
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\GetOrderStatus $parameters
     * @return \JonathanCosta\StructType\GetOrderStatusResponse|bool
     */
    public function GetOrderStatus(\JonathanCosta\StructType\GetOrderStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrdersStatus
     * Meta information extracted from the WSDL
     * - documentation: Retorna o status de vários pedidos | Retorna o status de vários pedidos | Retorna o status de vários pedidos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\GetOrdersStatus $parameters
     * @return \JonathanCosta\StructType\GetOrdersStatusResponse|bool
     */
    public function GetOrdersStatus(\JonathanCosta\StructType\GetOrdersStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrdersStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReturnAnalysis
     * Meta information extracted from the WSDL
     * - documentation: Retorna o status de pedidos que estão no clearsale em fila ou finalizados e que não foram setados como retornados | Retorna o status de pedidos que estão no clearsale em fila ou finalizados e que não foram setados como retornados
     * | Retorna o status de pedidos que estão no clearsale em fila ou finalizados e que não foram setados como retornados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\GetReturnAnalysis $parameters
     * @return \JonathanCosta\StructType\GetReturnAnalysisResponse|bool
     */
    public function GetReturnAnalysis(\JonathanCosta\StructType\GetReturnAnalysis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReturnAnalysis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAnalystComments
     * Meta information extracted from the WSDL
     * - documentation: Retorna os comentários dos analistas | Retorna os comentários dos analistas | Retorna os comentários dos analistas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\GetAnalystComments $parameters
     * @return \JonathanCosta\StructType\GetAnalystCommentsResponse|bool
     */
    public function GetAnalystComments(\JonathanCosta\StructType\GetAnalystComments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAnalystComments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuizURL
     * Meta information extracted from the WSDL
     * - documentation: Retorna a URL do Questionário para auto-validação | Retorna a URL do Questionário para auto-validação | Retorna a URL do Questionário para auto-validação
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\GetQuizURL $parameters
     * @return \JonathanCosta\StructType\GetQuizURLResponse|bool
     */
    public function GetQuizURL(\JonathanCosta\StructType\GetQuizURL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQuizURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPackageStatusCustom
     * Meta information extracted from the WSDL
     * - documentation: Retorna o status do pacote | Retorna o status do pacote | Retorna o status do pacote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \JonathanCosta\StructType\GetPackageStatusCustom $parameters
     * @return \JonathanCosta\StructType\GetPackageStatusCustomResponse|bool
     */
    public function GetPackageStatusCustom(\JonathanCosta\StructType\GetPackageStatusCustom $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPackageStatusCustom($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \JonathanCosta\StructType\GetAnalystCommentsResponse|\JonathanCosta\StructType\GetOrdersStatusResponse|\JonathanCosta\StructType\GetOrderStatusResponse|\JonathanCosta\StructType\GetPackageStatusCustomResponse|\JonathanCosta\StructType\GetPackageStatusResponse|\JonathanCosta\StructType\GetQuizURLResponse|\JonathanCosta\StructType\GetReturnAnalysisResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
