<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Telephone ServiceType
 * @subpackage Services
 */
class Telephone extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TelephoneFixeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Téléphone fixe de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function TelephoneFixeEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->TelephoneFixeEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TelephonePortableEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Téléphone portable de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function TelephonePortableEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->TelephonePortableEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
