<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Nom ServiceType
 * @subpackage Services
 */
class Nom extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NomEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Nom de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function NomEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NomEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NomJeuneFilleEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Nom de jeune fille de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function NomJeuneFilleEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NomJeuneFilleEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NomBaccalaureatDeCode
     * Meta information extracted from the WSDL
     * - documentation: Nom du baccalauréat (ou équivalence) correspondant au code 'ACode'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aCode
     * @return string|bool
     */
    public function NomBaccalaureatDeCode($aCode)
    {
        try {
            $this->setResult($this->getSoapClient()->NomBaccalaureatDeCode($aCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NomSpecialiteBacDeCode
     * Meta information extracted from the WSDL
     * - documentation: Nom de la spécialité BAC correspondant au code 'ACode'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aCode
     * @return string|bool
     */
    public function NomSpecialiteBacDeCode($aCode)
    {
        try {
            $this->setResult($this->getSoapClient()->NomSpecialiteBacDeCode($aCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NomDepartementDeCode
     * Meta information extracted from the WSDL
     * - documentation: Nom du département correspondant au code 'ACode'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aCode
     * @return string|bool
     */
    public function NomDepartementDeCode($aCode)
    {
        try {
            $this->setResult($this->getSoapClient()->NomDepartementDeCode($aCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NomTypeDernierDiplomeDeCode
     * Meta information extracted from the WSDL
     * - documentation: Nom du type du dernier diplôme obtenu correspondant au code 'ACode'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aCode
     * @return string|bool
     */
    public function NomTypeDernierDiplomeDeCode($aCode)
    {
        try {
            $this->setResult($this->getSoapClient()->NomTypeDernierDiplomeDeCode($aCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
