<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Nationalites ServiceType
 * @subpackage Services
 */
class Nationalites extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NationalitesTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Nationalité des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function NationalitesTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->NationalitesTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
