<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lieu ServiceType
 * @subpackage Services
 */
class Lieu extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LieuDeNaissanceEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Lieu de naissance de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function LieuDeNaissanceEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->LieuDeNaissanceEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
