<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ical ServiceType
 * @subpackage Services
 */
class Ical extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IcalEmploiDuTempsEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Dépréciée : Utiliser IcalEtudiant.Retourne une chaine correspondant à l'emploi du temps de l'étudiant sous format ICAL.Utiliser FormatTexteICAL et FormatTexteICALEnseignant (dans l'interface IHpSvcWAdmin) pour spécifier le
     * format désiré du texte.Attention! Le paramètre 'AAvecFuseauHoraire' est obsolète. On utilise toujours le fuseau horaire des paramètres Windows.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param \hp_\StructType\THpSvcWTableauSemaines $aDomaine
     * @param string $aAvecFuseauHoraire
     * @param string $aAvecDateSeances
     * @param string $aAvecType
     * @param string $aAvecPonderation
     * @param string $aAvecMemo
     * @param string $aAvecEffectif
     * @param string $aAvecSites
     * @param string $aFormatTexteMatiere
     * @param string $aFormatTexteEnseignants
     * @param string $aFormatTexteRegroupements
     * @param string $aFormatTextePromotions
     * @param string $aFormatTexteTD
     * @param string $aFormatTexteOptions
     * @param string $aFormatTexteSalles
     * @return string|bool
     */
    public function IcalEmploiDuTempsEtudiant($aEtudiant, \hp_\StructType\THpSvcWTableauSemaines $aDomaine, $aAvecFuseauHoraire, $aAvecDateSeances, $aAvecType, $aAvecPonderation, $aAvecMemo, $aAvecEffectif, $aAvecSites, $aFormatTexteMatiere, $aFormatTexteEnseignants, $aFormatTexteRegroupements, $aFormatTextePromotions, $aFormatTexteTD, $aFormatTexteOptions, $aFormatTexteSalles)
    {
        try {
            $this->setResult($this->getSoapClient()->IcalEmploiDuTempsEtudiant($aEtudiant, $aDomaine, $aAvecFuseauHoraire, $aAvecDateSeances, $aAvecType, $aAvecPonderation, $aAvecMemo, $aAvecEffectif, $aAvecSites, $aFormatTexteMatiere, $aFormatTexteEnseignants, $aFormatTexteRegroupements, $aFormatTextePromotions, $aFormatTexteTD, $aFormatTexteOptions, $aFormatTexteSalles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IcalEmploiDuTempsTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Dépréciée : Utiliser IcalTableauDEtudiants.Retourne un tableau de chaines correspondant aux emplois du temps des étudiants sous format ICAL.Utiliser FormatTexteICAL et FormatTexteICALEnseignant (dans l'interface IHpSvcWAdmin)
     * pour spécifier le format désiré du texte.Attention! Le paramètre 'AAvecFuseauHoraire' est obsolète. On utilise toujours le fuseau horaire des paramètres Windows.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @param \hp_\StructType\THpSvcWTableauSemaines $aDomaine
     * @param string $aAvecFuseauHoraire
     * @param string $aAvecDateSeances
     * @param string $aAvecType
     * @param string $aAvecPonderation
     * @param string $aAvecMemo
     * @param string $aAvecEffectif
     * @param string $aAvecSites
     * @param string $aFormatTexteMatiere
     * @param string $aFormatTexteEnseignants
     * @param string $aFormatTexteRegroupements
     * @param string $aFormatTextePromotions
     * @param string $aFormatTexteTD
     * @param string $aFormatTexteOptions
     * @param string $aFormatTexteSalles
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function IcalEmploiDuTempsTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau, \hp_\StructType\THpSvcWTableauSemaines $aDomaine, $aAvecFuseauHoraire, $aAvecDateSeances, $aAvecType, $aAvecPonderation, $aAvecMemo, $aAvecEffectif, $aAvecSites, $aFormatTexteMatiere, $aFormatTexteEnseignants, $aFormatTexteRegroupements, $aFormatTextePromotions, $aFormatTexteTD, $aFormatTexteOptions, $aFormatTexteSalles)
    {
        try {
            $this->setResult($this->getSoapClient()->IcalEmploiDuTempsTableauDEtudiants($aTableau, $aDomaine, $aAvecFuseauHoraire, $aAvecDateSeances, $aAvecType, $aAvecPonderation, $aAvecMemo, $aAvecEffectif, $aAvecSites, $aFormatTexteMatiere, $aFormatTexteEnseignants, $aFormatTexteRegroupements, $aFormatTextePromotions, $aFormatTexteTD, $aFormatTexteOptions, $aFormatTexteSalles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IcalEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Retourne une chaine correspondant à l'emploi du temps de l'étudiant sous format ICAL.Pour plus d'information sur THpSvcWTableauFormatICAL, aller dans la section 'Types définis dans le document WSDL'.Utiliser FormatTexteICAL et
     * FormatTexteICALEnseignant (dans l'interface IHpSvcWAdmin) pour spécifier le format désiré du texte.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param \hp_\StructType\THpSvcWTableauSemaines $aDomaine
     * @param \hp_\StructType\THpSvcWTableauFormatICAL $aOptions
     * @param string $aFormatTexteMatiere
     * @param string $aFormatTexteEnseignants
     * @param string $aFormatTexteRegroupements
     * @param string $aFormatTextePromotions
     * @param string $aFormatTexteTD
     * @param string $aFormatTexteOptions
     * @param string $aFormatTexteSalles
     * @return string|bool
     */
    public function IcalEtudiant($aEtudiant, \hp_\StructType\THpSvcWTableauSemaines $aDomaine, \hp_\StructType\THpSvcWTableauFormatICAL $aOptions, $aFormatTexteMatiere, $aFormatTexteEnseignants, $aFormatTexteRegroupements, $aFormatTextePromotions, $aFormatTexteTD, $aFormatTexteOptions, $aFormatTexteSalles)
    {
        try {
            $this->setResult($this->getSoapClient()->IcalEtudiant($aEtudiant, $aDomaine, $aOptions, $aFormatTexteMatiere, $aFormatTexteEnseignants, $aFormatTexteRegroupements, $aFormatTextePromotions, $aFormatTexteTD, $aFormatTexteOptions, $aFormatTexteSalles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IcalTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Retourne un tableau de chaines correspondant aux emplois du temps des étudiants sous format ICAL.Pour plus d'information sur THpSvcWTableauFormatICAL, aller dans la section 'Types définis dans le document WSDL'.Utiliser
     * FormatTexteICAL et FormatTexteICALEnseignant (dans l'interface IHpSvcWAdmin) pour spécifier le format désiré du texte.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @param \hp_\StructType\THpSvcWTableauSemaines $aDomaine
     * @param \hp_\StructType\THpSvcWTableauFormatICAL $aOptions
     * @param string $aFormatTexteMatiere
     * @param string $aFormatTexteEnseignants
     * @param string $aFormatTexteRegroupements
     * @param string $aFormatTextePromotions
     * @param string $aFormatTexteTD
     * @param string $aFormatTexteOptions
     * @param string $aFormatTexteSalles
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function IcalTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau, \hp_\StructType\THpSvcWTableauSemaines $aDomaine, \hp_\StructType\THpSvcWTableauFormatICAL $aOptions, $aFormatTexteMatiere, $aFormatTexteEnseignants, $aFormatTexteRegroupements, $aFormatTextePromotions, $aFormatTexteTD, $aFormatTexteOptions, $aFormatTexteSalles)
    {
        try {
            $this->setResult($this->getSoapClient()->IcalTableauDEtudiants($aTableau, $aDomaine, $aOptions, $aFormatTexteMatiere, $aFormatTexteEnseignants, $aFormatTexteRegroupements, $aFormatTextePromotions, $aFormatTexteTD, $aFormatTexteOptions, $aFormatTexteSalles));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\hp_\StructType\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
