<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Creer ServiceType
 * @subpackage Services
 */
class Creer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreerEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Crée un étudiant de nom 'ANom', prénom 'APrenom' et date de naissance 'ADateDeNaissance' dans la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @param string $aPrenom
     * @param string $aDateDeNaissance
     * @return THpSvcWCleEtudiant|bool
     */
    public function CreerEtudiant($aNom, $aPrenom, $aDateDeNaissance)
    {
        try {
            $this->setResult($this->getSoapClient()->CreerEtudiant($aNom, $aPrenom, $aDateDeNaissance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreerEtudiantAvecNumeroINE
     * Meta information extracted from the WSDL
     * - documentation: Crée un étudiant de nom 'ANom', prénom 'APrenom', date de naissance 'ADateDeNaissance' et numéro INE 'ANumeroINE' dans la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @param string $aPrenom
     * @param string $aDateDeNaissance
     * @param string $aNumeroINE
     * @return THpSvcWCleEtudiant|bool
     */
    public function CreerEtudiantAvecNumeroINE($aNom, $aPrenom, $aDateDeNaissance, $aNumeroINE)
    {
        try {
            $this->setResult($this->getSoapClient()->CreerEtudiantAvecNumeroINE($aNom, $aPrenom, $aDateDeNaissance, $aNumeroINE));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreerEtudiantAvecIdentifiant
     * Meta information extracted from the WSDL
     * - documentation: Crée un étudiant de nom 'ANom', prénom 'APrenom', date de naissance 'ADateDeNaissance' et identifiant 'AIdentifiant' dans la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @param string $aPrenom
     * @param string $aDateDeNaissance
     * @param string $aIdentifiant
     * @return THpSvcWCleEtudiant|bool
     */
    public function CreerEtudiantAvecIdentifiant($aNom, $aPrenom, $aDateDeNaissance, $aIdentifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->CreerEtudiantAvecIdentifiant($aNom, $aPrenom, $aDateDeNaissance, $aIdentifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreerEtudiantAvecNumeroINEEtIdentifiant
     * Meta information extracted from the WSDL
     * - documentation: Crée un étudiant de nom 'ANom', prénom 'APrenom', date de naissance 'ADateDeNaissance', numéro INE 'ANumeroINE' et identifiant 'AIdentifiant' dans la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @param string $aPrenom
     * @param string $aDateDeNaissance
     * @param string $aNumeroINE
     * @param string $aIdentifiant
     * @return THpSvcWCleEtudiant|bool
     */
    public function CreerEtudiantAvecNumeroINEEtIdentifiant($aNom, $aPrenom, $aDateDeNaissance, $aNumeroINE, $aIdentifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->CreerEtudiantAvecNumeroINEEtIdentifiant($aNom, $aPrenom, $aDateDeNaissance, $aNumeroINE, $aIdentifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreerEtablissementOrigine
     * Meta information extracted from the WSDL
     * - documentation: Crée l'établissement d'origine de nom 'ANomEtablissement' et e-mail 'AEmailEtablissement' seulement s'il n'existe pas. Renvoie une exception s'il y a déjà un établissement origine avec le même nom ou la même adresse mail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNomEtablissement
     * @param string $aEmailEtablissement
     * @return void|bool
     */
    public function CreerEtablissementOrigine($aNomEtablissement, $aEmailEtablissement)
    {
        try {
            $this->setResult($this->getSoapClient()->CreerEtablissementOrigine($aNomEtablissement, $aEmailEtablissement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return THpSvcWCleEtudiant|void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
