<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Aucune ServiceType
 * @subpackage Services
 */
class Aucune extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AucuneDateDeNaissance
     * Meta information extracted from the WSDL
     * - documentation: Date signifiant qu'aucune date de naissance n'est attribuée à l'étudiant
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return date|bool
     */
    public function AucuneDateDeNaissance()
    {
        try {
            $this->setResult($this->getSoapClient()->AucuneDateDeNaissance());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return date
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
