<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Parent ServiceType
 * @subpackage Services
 */
class _Parent extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Parent1Etudiant
     * Meta information extracted from the WSDL
     * - documentation: Clé du parent 1 associé à l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return THpSvcWCleParent|bool
     */
    public function Parent1Etudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->Parent1Etudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Parent2Etudiant
     * Meta information extracted from the WSDL
     * - documentation: Clé du parent 2 associé à l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return THpSvcWCleParent|bool
     */
    public function Parent2Etudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->Parent2Etudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return THpSvcWCleParent
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
