<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for URLI ServiceType
 * @subpackage Services
 */
class URLI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named URLIcalEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Retourne le suffixe de l'URL de l'ICAL de l'étudiant de clé 'AEtudiant' sur l'année scolaire pour l'espace Etudiant.Ne pas oublier d'ajouter l'url publique de votre .Net devant pour avoir l'URL complète.En consultation, ne
     * retourne que les URL déjà générées, renvoie une exception sinon. (Pour générer les URL, lancer avec un compte Modifiant ou supérieur)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function URLIcalEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->URLIcalEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named URLIcalTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Retourne les suffixes des URL des ICAL des étudiants dont la clé est dans 'ATableau' sur l'année scolaire pour l'espace Etudiant.Ne pas oublier d'ajouter l'url publique de votre .Net devant pour avoir l'URL complète.En
     * consultation, ne retourne que les URL déjà générées, vide sinon. (Pour générer les URL, lancer avec un compte Modifiant ou supérieur)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function URLIcalTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->URLIcalTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\hp_\StructType\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
