<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Regroupements ServiceType
 * @subpackage Services
 */
class Regroupements extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegroupementsEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des regroupements de l'étudiant de clé 'AEtudiant' à la date d'aujourd'hui
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return \hp_\StructType\THpSvcWTableauClesRegroupements|bool
     */
    public function RegroupementsEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->RegroupementsEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegroupementsEtudiantALaDate
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des regroupements de l'étudiant de clé 'AEtudiant' à la date 'ADate'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDate
     * @return \hp_\StructType\THpSvcWTableauClesRegroupements|bool
     */
    public function RegroupementsEtudiantALaDate($aEtudiant, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->RegroupementsEtudiantALaDate($aEtudiant, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegroupementsEtudiantEntre2Dates
     * Meta information extracted from the WSDL
     * - documentation: Clés des regroupements où l'étudiant de clé 'AEtudiant' a été inscrit au moins un jour entre 'ADateDebut' et 'ADateFin'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDateDebut
     * @param string $aDateFin
     * @return \hp_\StructType\THpSvcWTableauClesRegroupements|bool
     */
    public function RegroupementsEtudiantEntre2Dates($aEtudiant, $aDateDebut, $aDateFin)
    {
        try {
            $this->setResult($this->getSoapClient()->RegroupementsEtudiantEntre2Dates($aEtudiant, $aDateDebut, $aDateFin));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauClesRegroupements
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
