<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Photo ServiceType
 * @subpackage Services
 */
class Photo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PhotoEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Flux de la photo de l'étudiant de clé 'AEtudiant' au format 'AFormat'. La valeur de retour est vide si l'étudiant n'a pas de photo.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aFormat
     * @return base64Binary|bool
     */
    public function PhotoEtudiant($aEtudiant, $aFormat)
    {
        try {
            $this->setResult($this->getSoapClient()->PhotoEtudiant($aEtudiant, $aFormat));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return base64Binary
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
