<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Numero ServiceType
 * @subpackage Services
 */
class Numero extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NumeroINEEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Numéro INE de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function NumeroINEEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NumeroINEEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NumeroDOrdreEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Numéro d'ordre de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function NumeroDOrdreEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NumeroDOrdreEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NumeroSecuriteSocialeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Numéro de sécurité sociale de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function NumeroSecuriteSocialeEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NumeroSecuriteSocialeEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NumeroContratEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Numéro de contrat de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function NumeroContratEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NumeroContratEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
