<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ne ServiceType
 * @subpackage Services
 */
class Ne extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NePasRenseignerCotisationEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Efface la cotisation à une mutuelle de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return void|bool
     */
    public function NePasRenseignerCotisationEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NePasRenseignerCotisationEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NePasPublierLEtudiantSurLesEspaces
     * Meta information extracted from the WSDL
     * - documentation: Permet de ne pas publier l'étudiant de clé 'AEtudiant' sur tous les espaces du .Net (Toujours publié sur l'espace secrétariat et appariteur)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return void|bool
     */
    public function NePasPublierLEtudiantSurLesEspaces($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NePasPublierLEtudiantSurLesEspaces($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
