<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Motif ServiceType
 * @subpackage Services
 */
class Motif extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MotifNonCotisationEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Motif de non cotisation à une mutuelle de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function MotifNonCotisationEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->MotifNonCotisationEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
