<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Le ServiceType
 * @subpackage Services
 */
class Le_1 extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LeTableauDEtudiantsSontRedoublants
     * Meta information extracted from the WSDL
     * - documentation: Tableau de booléens indiquant si les étudiants dont la clé est dans 'ATableau' sont redoublants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauBooleens|bool
     */
    public function LeTableauDEtudiantsSontRedoublants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->LeTableauDEtudiantsSontRedoublants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauBooleens
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
