<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Etudiants ServiceType
 * @subpackage Services
 */
class Etudiants extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EtudiantsPubliesSurTousLesEspaces
     * Meta information extracted from the WSDL
     * - documentation: Tableau de booléen indiquant si les étudiants dont la clé est dans 'ATableau' sont publiés sur tous les espaces du .Net
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauBooleens|bool
     */
    public function EtudiantsPubliesSurTousLesEspaces(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantsPubliesSurTousLesEspaces($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EtudiantsPromotion
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des étudiants de promotion de clé 'APromotion' à la date d'aujourd'hui
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aPromotion
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function EtudiantsPromotion($aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantsPromotion($aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EtudiantsPromotionALaDate
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des étudiants de la promotion de clé 'APromotion' à la date 'ADate'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aPromotion
     * @param string $aDate
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function EtudiantsPromotionALaDate($aPromotion, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantsPromotionALaDate($aPromotion, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EtudiantsPromotionEntre2Dates
     * Meta information extracted from the WSDL
     * - documentation: Clés des étudiants qui ont été inscrits au moins un jour dans la promotion de clé 'APromotion' entre 'ADateDebut' et 'ADateFin'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aPromotion
     * @param string $aDateDebut
     * @param string $aDateFin
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function EtudiantsPromotionEntre2Dates($aPromotion, $aDateDebut, $aDateFin)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantsPromotionEntre2Dates($aPromotion, $aDateDebut, $aDateFin));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EtudiantsTDOption
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des étudiants de TD/option de clé 'ATDOption' à la date d'aujourd'hui
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aTDOption
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function EtudiantsTDOption($aTDOption)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantsTDOption($aTDOption));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EtudiantsTDOptionALaDate
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des étudiants de TD/option de clé 'ATDOption' à la date 'ADate'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aTDOption
     * @param string $aDate
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function EtudiantsTDOptionALaDate($aTDOption, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantsTDOptionALaDate($aTDOption, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EtudiantsTDOptionEntre2Dates
     * Meta information extracted from the WSDL
     * - documentation: Clés des étudiants qui ont été inscrits au moins un jour dans le TD/option de clé 'ATDOption' entre 'ADateDebut' et 'ADateFin'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aTDOption
     * @param string $aDateDebut
     * @param string $aDateFin
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function EtudiantsTDOptionEntre2Dates($aTDOption, $aDateDebut, $aDateFin)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantsTDOptionEntre2Dates($aTDOption, $aDateDebut, $aDateFin));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EtudiantsCours
     * Meta information extracted from the WSDL
     * - documentation: Clés des étudiants du cours de clé 'ACours'. Utiliser la fonction EtudiantsDuCours dans l'interface IHpSvcWCours.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aCours
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function EtudiantsCours($aCours)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantsCours($aCours));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauBooleens|\hp_\StructType\THpSvcWTableauClesEtudiants
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
